/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ArbitrarySet<T>
extends AbstractArbitrarySet<T> {
    private final T value;
    private long limit;

    public ArbitrarySet(ArbitraryExpression arbitraryExpression, T value, long limit) {
        super(arbitraryExpression);
        this.value = value;
        this.limit = limit;
    }

    public ArbitrarySet(ArbitraryExpression arbitraryExpression, T value) {
        this(arbitraryExpression, value, Integer.MAX_VALUE);
    }

    @Nullable
    public T getApplicableValue() {
        if (this.limit > 0L) {
            --this.limit;
            return this.value;
        }
        return null;
    }

    @Override
    public boolean isApplicable() {
        return this.limit > 0L;
    }

    @Override
    public Object getInputValue() {
        return this.value;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public ArbitrarySet<T> copy() {
        return new ArbitrarySet<T>(this.getArbitraryExpression(), this.value, this.limit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArbitrarySet that = (ArbitrarySet)obj;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

