/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.OldArbitraryBuilderImpl;
import com.navercorp.fixturemonkey.arbitrary.AbstractArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySetArbitrary;
import com.navercorp.fixturemonkey.arbitrary.BuilderManipulator;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ArbitrarySetLazyValue<T>
extends AbstractArbitrarySet<T> {
    private final Supplier<T> supplier;
    private long limit;

    public ArbitrarySetLazyValue(ArbitraryExpression arbitraryExpression, Supplier<T> supplier, long limit) {
        super(arbitraryExpression);
        this.supplier = supplier;
        this.limit = limit;
    }

    public ArbitrarySetLazyValue(ArbitraryExpression arbitraryExpression, Supplier<T> supplier) {
        this(arbitraryExpression, supplier, Long.MAX_VALUE);
    }

    @Override
    public void accept(OldArbitraryBuilderImpl arbitraryBuilder) {
        ArbitraryExpression arbitraryExpression = this.getArbitraryExpression();
        T value = this.getApplicableValue();
        long limit = this.limit;
        AbstractArbitrarySet builderManipulator = value instanceof Arbitrary ? new ArbitrarySetArbitrary(arbitraryExpression, (Arbitrary)value, limit) : new ArbitrarySet<T>(arbitraryExpression, value, limit);
        arbitraryBuilder.apply((BuilderManipulator)builderManipulator);
    }

    @Nullable
    public T getApplicableValue() {
        if (this.limit > 0L) {
            --this.limit;
            return this.getInputValue();
        }
        return null;
    }

    @Override
    public boolean isApplicable() {
        return this.limit > 0L;
    }

    public T getInputValue() {
        return this.supplier.get();
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public ArbitrarySetLazyValue<T> copy() {
        return this;
    }
}

