/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.TypeSupports;
import com.navercorp.fixturemonkey.arbitrary.AbstractArbitraryExpressionManipulator;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpression;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.PostArbitraryManipulator;
import java.util.Objects;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;

public final class ArbitrarySetPostCondition<T>
extends AbstractArbitraryExpressionManipulator
implements PostArbitraryManipulator<T> {
    private final Class<T> clazz;
    private final Predicate<T> filter;
    private long limit;

    public ArbitrarySetPostCondition(Class<T> clazz, ArbitraryExpression arbitraryExpression, Predicate<T> filter, long limit) {
        super(arbitraryExpression);
        this.clazz = clazz;
        this.filter = filter;
        this.limit = limit;
    }

    public ArbitrarySetPostCondition(Class<T> clazz, ArbitraryExpression arbitraryExpression, Predicate<T> filter) {
        this(clazz, arbitraryExpression, filter, Integer.MAX_VALUE);
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Predicate<T> getFilter() {
        return this.filter;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public Arbitrary<T> apply(Arbitrary<T> from) {
        if (this.limit > 0L) {
            --this.limit;
            return from.filter(this.filter);
        }
        return from;
    }

    @Override
    public boolean isMappableTo(ArbitraryNode<T> arbitraryNode) {
        Class<?> nodeClazz = arbitraryNode.getType().getType();
        return TypeSupports.isCompatibleType(this.clazz, nodeClazz) || this.clazz.isAssignableFrom(nodeClazz);
    }

    @Override
    public ArbitrarySetPostCondition<T> copy() {
        return new ArbitrarySetPostCondition<T>(this.clazz, this.getArbitraryExpression(), this.filter, this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitrarySetPostCondition that = (ArbitrarySetPostCondition)obj;
        return this.clazz.equals(that.clazz) && this.getArbitraryExpression().equals(that.getArbitraryExpression()) && this.filter.equals(that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.getArbitraryExpression(), this.filter);
    }
}

