/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.ArbitraryOption;
import com.navercorp.fixturemonkey.TypeSupports;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryTree;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ArrayArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.DefaultContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.InterfaceSupplier;
import com.navercorp.fixturemonkey.arbitrary.MapArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.arbitrary.OptionalArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.generator.AnnotatedArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.AnnotationSource;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;

public final class ArbitraryTraverser {
    public static final ArbitraryTraverser INSTANCE = new ArbitraryTraverser(ArbitraryOption.DEFAULT_ARBITRARY_OPTIONS);
    private final ArbitraryOption arbitraryOption;

    public ArbitraryTraverser(ArbitraryOption arbitraryOption) {
        this.arbitraryOption = arbitraryOption;
    }

    public <T> void traverse(ArbitraryTree<T> tree, boolean keyOfMapStructure, PropertyNameResolver propertyNameResolver) {
        this.traverse(tree.getHead(), keyOfMapStructure, propertyNameResolver);
    }

    public <T> void traverse(ArbitraryNode<T> node, boolean keyOfMapStructure, PropertyNameResolver propertyNameResolver) {
        LazyArbitrary<T> value = node.getValue();
        if (value != null) {
            value.clear();
        }
        this.doTraverse(node, keyOfMapStructure, true, propertyNameResolver);
    }

    @Deprecated
    public <T> void traverse(ArbitraryTree<T> tree, boolean keyOfMapStructure, FieldNameResolver fieldNameResolver) {
        this.traverse(tree.getHead(), keyOfMapStructure, fieldNameResolver);
    }

    @Deprecated
    public <T> void traverse(ArbitraryNode<T> node, boolean keyOfMapStructure, FieldNameResolver fieldNameResolver) {
        LazyArbitrary<T> value = node.getValue();
        if (value != null) {
            value.clear();
        }
        this.doTraverse(node, keyOfMapStructure, true, new PropertyNameResolverAdapter(fieldNameResolver));
    }

    private <T> void doTraverse(ArbitraryNode<T> node, boolean keyOfMapStructure, boolean active, PropertyNameResolver propertyNameResolver) {
        node.getChildren().clear();
        this.initializeDefaultArbitrary(node);
        LazyArbitrary<T> nowValue = node.getValue();
        ArbitraryType<T> nowNodeType = node.getType();
        Class<?> clazz = nowNodeType.getType();
        ContainerArbitraryNodeGenerator containerArbitraryNodeGenerator = this.arbitraryOption.getContainerArbitraryNodeGenerator(nowNodeType.getType());
        if (this.isTraversable(nowNodeType)) {
            List<Field> fields = TypeSupports.extractFields(clazz);
            for (Field field : fields) {
                boolean nextActive;
                FieldProperty property = new FieldProperty(field);
                ArbitraryType arbitraryType = new ArbitraryType(Types.getActualType((Type)property.getType()), property.getAnnotatedType(), property.getAnnotations());
                double nullInject = this.arbitraryOption.getNullInject();
                boolean defaultNotNull = this.arbitraryOption.isDefaultNotNull();
                boolean nullable = this.isNullableField(arbitraryType, field, defaultNotNull);
                LazyArbitrary<?> nextValue = this.getNextValue(nowValue, (Property)property);
                nullable = nextValue == null && nullable;
                boolean bl = nextActive = (nextValue == null || nextValue.getValue() != null) && active;
                if (node.isDecomposedAsNull()) {
                    node.setArbitrary(Arbitraries.just(null));
                }
                ArbitraryNode<LazyArbitrary<?>> nextNode = ArbitraryNode.builder().type(arbitraryType).propertyName(propertyNameResolver.resolve((Property)property)).nullable(nullable).nullInject(nullInject).keyOfMapStructure(keyOfMapStructure).value(nextValue).active(nextActive).build();
                node.addChildNode(nextNode);
                this.doTraverse(nextNode, false, active, propertyNameResolver);
            }
        } else if (nowNodeType.isContainer() || containerArbitraryNodeGenerator != null) {
            if (containerArbitraryNodeGenerator != null) {
                this.traverseContainer(node, active, propertyNameResolver, containerArbitraryNodeGenerator);
            } else if (nowNodeType.isMap() || nowNodeType.isMapEntry()) {
                this.traverseContainer(node, active, propertyNameResolver, MapArbitraryNodeGenerator.INSTANCE);
            } else if (nowNodeType.isArray()) {
                this.traverseContainer(node, active, propertyNameResolver, ArrayArbitraryNodeGenerator.INSTANCE);
            } else if (nowNodeType.isOptional()) {
                this.traverseContainer(node, active, propertyNameResolver, OptionalArbitraryNodeGenerator.INSTANCE);
            } else {
                this.traverseContainer(node, active, propertyNameResolver, DefaultContainerArbitraryNodeGenerator.INSTANCE);
            }
        } else if (nowValue != null) {
            node.setManipulated(true);
            node.setArbitrary(Arbitraries.just((Object)nowValue.getValue()));
        } else if (this.arbitraryOption.isDefaultArbitraryType(nowNodeType.getType()) && this.arbitraryOption.isGeneratableClass(clazz)) {
            Arbitrary<T> registeredArbitrary = this.registeredArbitrary(node);
            node.setArbitrary(registeredArbitrary);
        } else if (nowNodeType.isEnum()) {
            Arbitrary arbitrary = Arbitraries.of(clazz);
            node.setArbitrary(arbitrary);
        } else if (nowNodeType.isInterface() || nowNodeType.isAbstract()) {
            InterfaceSupplier<?> interfaceSupplier = this.arbitraryOption.getInterfaceSupplierOrDefault(nowNodeType.getType());
            node.setArbitrary(Arbitraries.just(interfaceSupplier.get(nowNodeType.getType())));
        } else {
            node.setArbitrary(Arbitraries.just(null));
        }
    }

    private <T> void traverseContainer(ArbitraryNode<T> currentNode, boolean active, PropertyNameResolver propertyNameResolver, ContainerArbitraryNodeGenerator containerArbitraryNodeGenerator) {
        List<ArbitraryNode<?>> nodes = containerArbitraryNodeGenerator.generate(currentNode);
        for (ArbitraryNode<?> node : nodes) {
            currentNode.addChildNode(node);
            this.doTraverse(node, node.isKeyOfMapStructure(), active, propertyNameResolver);
        }
    }

    private <T> Arbitrary<T> registeredArbitrary(ArbitraryNode<T> currentNode) {
        ArbitraryType<T> type = currentNode.getType();
        AnnotatedType argsType = type.getAnnotatedType();
        Class<?> clazz = argsType != null ? Types.getActualType((AnnotatedType)argsType) : type.getType();
        AnnotationSource annotationSource = new AnnotationSource(type.getAnnotations());
        Map<Class<?>, AnnotatedArbitraryGenerator<?>> annotatedArbitraryMap = this.arbitraryOption.getAnnotatedArbitraryMap();
        return Optional.ofNullable(annotatedArbitraryMap.get(clazz)).map(arbitraryGenerator -> arbitraryGenerator.generate(annotationSource)).orElseThrow(() -> new IllegalArgumentException("Class is not registered " + clazz.getName()));
    }

    @Nullable
    private <T> LazyArbitrary<?> getNextValue(LazyArbitrary<T> currentValue, Property property) {
        if (currentValue == null) {
            return null;
        }
        return currentValue.getValue() == null ? LazyArbitrary.lazy(() -> null, (boolean)true) : LazyArbitrary.lazy(() -> property.getValue(currentValue.getValue()), (boolean)true);
    }

    private <T> void initializeDefaultArbitrary(ArbitraryNode<T> node) {
        Class<?> clazz;
        ArbitraryBuilder<?> defaultArbitraryBuilder;
        if (!node.isHead() && node.getValue() == null && (defaultArbitraryBuilder = this.arbitraryOption.getDefaultArbitraryBuilder(clazz = node.getType().getType())) != null) {
            node.setValue(() -> defaultArbitraryBuilder.sample());
            node.setManipulated(true);
        }
    }

    private boolean isNullableField(ArbitraryType<?> arbitraryType, Field field, boolean defaultNotNull) {
        boolean nullable = this.arbitraryOption.getNullableArbitraryEvaluator().isNullable(field);
        if (arbitraryType.isContainer()) {
            return nullable && this.arbitraryOption.isNullableContainer();
        }
        if (arbitraryType.isPrimitive()) {
            return false;
        }
        if (arbitraryType.getAnnotation(NotEmpty.class) != null || field.getType() == String.class && arbitraryType.getAnnotation(NotBlank.class) != null) {
            return false;
        }
        if (arbitraryType.getAnnotation(Nullable.class) != null) {
            return true;
        }
        if (!nullable) {
            return false;
        }
        boolean hasNotNullAnnotations = arbitraryType.getAnnotations().stream().noneMatch(this.arbitraryOption::isNonNullAnnotation);
        if (!hasNotNullAnnotations) {
            return false;
        }
        return !defaultNotNull;
    }

    private boolean isTraversable(ArbitraryType<?> type) {
        Class<?> clazz = type.getType();
        if (clazz == null) {
            return false;
        }
        return this.arbitraryOption.isExceptGeneratablePackage(clazz) && this.arbitraryOption.isGeneratableClass(clazz) && !this.arbitraryOption.isDefaultArbitraryType(clazz) && this.arbitraryOption.getContainerArbitraryNodeGenerator(clazz) == null && !type.isContainer() && !type.isOptional() && !type.isEnum() && !type.isInterface() && !type.isAbstract();
    }

    private static class PropertyNameResolverAdapter
    implements FieldNameResolver,
    PropertyNameResolver {
        private final FieldNameResolver fieldNameResolver;

        PropertyNameResolverAdapter(FieldNameResolver fieldNameResolver) {
            this.fieldNameResolver = fieldNameResolver;
        }

        @Override
        public String resolveFieldName(Field field) {
            return this.fieldNameResolver.resolveFieldName(field);
        }

        public String resolve(Property property) {
            FieldProperty fieldProperty = (FieldProperty)property;
            return this.fieldNameResolver.resolveFieldName(fieldProperty.getField());
        }
    }
}

