/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.Arbitraries;

public class ArrayArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final ArrayArbitraryNodeGenerator INSTANCE = new ArrayArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> containerNode) {
        int currentIndex = 0;
        ArbitraryType<T> clazz = containerNode.getType();
        ArbitraryType childType = clazz.getArrayArbitraryType();
        String propertyName = containerNode.getPropertyName();
        LazyArbitrary<T> lazyValue = containerNode.getValue();
        ArrayList generatedNodeList = new ArrayList();
        int elementSize = containerNode.getElementSize();
        if (lazyValue != null) {
            Object value = lazyValue.getValue();
            if (value == null) {
                containerNode.setArbitrary(Arbitraries.just(null));
                return generatedNodeList;
            }
            int length = Array.getLength(value);
            for (currentIndex = 0; currentIndex < length && (containerNode.isNotSetContainerSize() || currentIndex < elementSize); ++currentIndex) {
                Object nextValue = Array.get(value, currentIndex);
                ArbitraryNode<Object> nextNode = ArbitraryNode.builder().type(childType).propertyName(propertyName).indexOfIterable(currentIndex).value(nextValue).build();
                generatedNodeList.add(nextNode);
            }
        }
        if (lazyValue == null || !containerNode.isNotSetContainerSize()) {
            for (int i = currentIndex; i < elementSize; ++i) {
                ArbitraryNode genericFrame = ArbitraryNode.builder().type(childType).propertyName(propertyName).indexOfIterable(i).nullable(false).nullInject(0.0).build();
                generatedNodeList.add(genericFrame);
            }
        }
        containerNode.setContainerSizeConstraint(null);
        return generatedNodeList;
    }

    @Override
    @Deprecated
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        return this.generate(nowNode);
    }
}

