/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import net.jqwik.api.Arbitraries;

public class DefaultContainerArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final DefaultContainerArbitraryNodeGenerator INSTANCE = new DefaultContainerArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> containerNode) {
        ArbitraryType<T> clazz = containerNode.getType();
        LazyArbitrary<T> lazyValue = containerNode.getValue();
        String propertyName = containerNode.getPropertyName();
        ArbitraryType elementType = clazz.getGenericArbitraryType(0);
        ArrayList generatedNodeList = new ArrayList();
        int elementSize = containerNode.getElementSize();
        if (lazyValue != null) {
            if (lazyValue.getValue() == null) {
                containerNode.setArbitrary(Arbitraries.just(null));
                return generatedNodeList;
            }
            Object value = lazyValue.getValue();
            if (!(value instanceof Collection || value instanceof Iterator || value instanceof Stream)) {
                throw new IllegalArgumentException("Unsupported container type is given. " + value.getClass().getName());
            }
            Iterator iterator = this.toIterator(value);
            for (int currentIndex = 0; (containerNode.isNotSetContainerSize() || currentIndex < elementSize) && iterator.hasNext(); ++currentIndex) {
                Object nextObject = iterator.next();
                ArbitraryNode nextNode = ArbitraryNode.builder().type(elementType).value(nextObject).propertyName(propertyName).indexOfIterable(currentIndex).build();
                generatedNodeList.add(nextNode);
            }
        }
        if (lazyValue == null || !containerNode.isNotSetContainerSize()) {
            for (int i = currentIndex; i < elementSize; ++i) {
                ArbitraryNode nextNode = ArbitraryNode.builder().type(elementType).propertyName(propertyName).indexOfIterable(i).nullable(false).nullInject(0.0).build();
                generatedNodeList.add(nextNode);
            }
        }
        containerNode.setContainerSizeConstraint(null);
        return generatedNodeList;
    }

    @Override
    @Deprecated
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        return this.generate(nowNode);
    }

    private <T, U> Iterator<U> toIterator(T value) {
        if (value instanceof Collection) {
            return ((Collection)value).iterator();
        }
        if (value instanceof Stream) {
            return ((Stream)value).iterator();
        }
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value instanceof ListIterator) {
            ListIterator listIter = (ListIterator)value;
            int listIteratorCursor = 0;
            while (listIter.hasPrevious()) {
                listIter.previous();
                ++listIteratorCursor;
            }
            ArrayList copied = new ArrayList();
            while (listIter.hasNext()) {
                copied.add(listIter.next());
            }
            if (listIter.previousIndex() + 1 == listIteratorCursor) {
                return copied.iterator();
            }
            int prevSize = listIter.previousIndex() + 1 - listIteratorCursor;
            for (int i = 0; i < prevSize; ++i) {
                listIter.previous();
            }
            return copied.iterator();
        }
        return (Iterator)value;
    }
}

