/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.Arbitraries;

public class MapArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final MapArbitraryNodeGenerator INSTANCE = new MapArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> containerNode) {
        ArrayList generatedNodeList = new ArrayList();
        LazyArbitrary<T> lazyValue = containerNode.getValue();
        if (lazyValue != null) {
            containerNode.setArbitrary(Arbitraries.just((Object)lazyValue.getValue()));
            return generatedNodeList;
        }
        ArbitraryType<T> clazz = containerNode.getType();
        String propertyName = containerNode.getPropertyName();
        ArbitraryType keyType = clazz.getGenericArbitraryType(0);
        ArbitraryType valueType = clazz.getGenericArbitraryType(1);
        int elementSize = containerNode.getElementSize();
        if (clazz.isMapEntry()) {
            elementSize = 1;
        }
        for (int i = 0; i < elementSize; ++i) {
            ArbitraryNode keyNode = ArbitraryNode.builder().type(keyType).propertyName(propertyName).indexOfIterable(i).keyOfMapStructure(true).nullInject(0.0).build();
            generatedNodeList.add(keyNode);
            ArbitraryNode valueNode = ArbitraryNode.builder().type(valueType).propertyName(propertyName).indexOfIterable(i).nullInject(0.0).build();
            generatedNodeList.add(valueNode);
        }
        containerNode.setContainerSizeConstraint(null);
        return generatedNodeList;
    }

    @Override
    @Deprecated
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        return this.generate(nowNode);
    }
}

