/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.arbitrary;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.arbitrary.ContainerArbitraryNodeGenerator;
import com.navercorp.fixturemonkey.generator.FieldNameResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Arbitraries;

public class OptionalArbitraryNodeGenerator
implements ContainerArbitraryNodeGenerator {
    public static final OptionalArbitraryNodeGenerator INSTANCE = new OptionalArbitraryNodeGenerator();

    @Override
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> containerNode) {
        ArrayList generatedNodeList = new ArrayList();
        ArbitraryType<T> arbitraryType = containerNode.getType();
        ArbitraryType elementType = arbitraryType.getGenericArbitraryType(0);
        String propertyName = containerNode.getPropertyName();
        LazyArbitrary<T> lazyValue = containerNode.getValue();
        if (lazyValue != null) {
            Object value = lazyValue.getValue();
            if (value == null) {
                containerNode.setArbitrary(Arbitraries.just(null));
                return generatedNodeList;
            }
            Optional optional = (Optional)value;
            Object nextObject = optional.orElse(null);
            LazyArbitrary nextLazyValue = LazyArbitrary.lazy(() -> nextObject, (boolean)true);
            if (nextLazyValue.getValue() == null) {
                return generatedNodeList;
            }
            ArbitraryNode<LazyArbitrary> nextNode = ArbitraryNode.builder().type(elementType).value(nextLazyValue).propertyName(propertyName).indexOfIterable(0).build();
            generatedNodeList.add(nextNode);
        }
        return generatedNodeList;
    }

    @Override
    @Deprecated
    public <T> List<ArbitraryNode<?>> generate(ArbitraryNode<T> nowNode, FieldNameResolver fieldNameResolver) {
        return this.generate(nowNode);
    }
}

