/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.resolver.ArbitraryManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.CompositeNodeResolver;
import com.navercorp.fixturemonkey.resolver.ContainerElementPredicate;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.DefaultNodeResolver;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.NodeAllEntryPredicate;
import com.navercorp.fixturemonkey.resolver.NodeEntryPredicate;
import com.navercorp.fixturemonkey.resolver.NodeKeyValuePredicate;
import com.navercorp.fixturemonkey.resolver.NodeManipulator;
import com.navercorp.fixturemonkey.resolver.NodeNullityManipulator;
import com.navercorp.fixturemonkey.resolver.NodeResolver;
import com.navercorp.fixturemonkey.resolver.NodeSetDecomposedValueManipulator;
import com.navercorp.fixturemonkey.resolver.NodeSetLazyManipulator;
import com.navercorp.fixturemonkey.resolver.PropertyNameNodePredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class InnerSpec {
    private final ArbitraryTraverser traverser;
    private final ManipulateOptions manipulateOptions;
    private final NodeResolver treePathResolver;
    private int min = 0;
    private int max = 3;
    private int entrySize = 0;
    private final List<ArbitraryManipulator> arbitraryManipulators;
    private final List<ContainerInfoManipulator> containerInfoManipulators;

    public InnerSpec(ArbitraryTraverser traverser, ManipulateOptions manipulateOptions, NodeResolver treePathResolver) {
        this.traverser = traverser;
        this.manipulateOptions = manipulateOptions;
        this.treePathResolver = treePathResolver;
        this.arbitraryManipulators = new ArrayList<ArbitraryManipulator>();
        this.containerInfoManipulators = new ArrayList<ContainerInfoManipulator>();
    }

    public InnerSpec minSize(int min) {
        return this.size(min, min + 3);
    }

    public InnerSpec maxSize(int max) {
        return this.size(Math.max(0, max - 3), max);
    }

    public InnerSpec size(int size) {
        return this.size(size, size);
    }

    public InnerSpec size(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("should be min > max, min : " + min + " max : " + max);
        }
        this.min = min;
        this.max = max;
        this.containerInfoManipulators.add(new ContainerInfoManipulator(this.treePathResolver, new ArbitraryContainerInfo(this.min, this.max, true)));
        return this;
    }

    public InnerSpec key(Object key) {
        ++this.entrySize;
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(true))), this.convertToNodeManipulator(key)));
        return this;
    }

    public InnerSpec key(Consumer<InnerSpec> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Map key cannot be null.");
        }
        ++this.entrySize;
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(true)));
        InnerSpec innerSpec = new InnerSpec(this.traverser, this.manipulateOptions, nextResolver);
        consumer.accept(innerSpec);
        this.arbitraryManipulators.addAll(innerSpec.arbitraryManipulators);
        this.containerInfoManipulators.addAll(innerSpec.containerInfoManipulators);
        return this;
    }

    public InnerSpec value(@Nullable Object value) {
        this.setValue(value);
        return this;
    }

    public InnerSpec value(Consumer<InnerSpec> consumer) {
        if (consumer == null) {
            this.setValue(null);
            return this;
        }
        ++this.entrySize;
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(false)));
        InnerSpec innerSpec = new InnerSpec(this.traverser, this.manipulateOptions, nextResolver);
        consumer.accept(innerSpec);
        this.arbitraryManipulators.addAll(innerSpec.arbitraryManipulators);
        this.containerInfoManipulators.addAll(innerSpec.containerInfoManipulators);
        this.containerInfoManipulators.add(new ContainerInfoManipulator(this.treePathResolver, new ArbitraryContainerInfo(this.entrySize + this.min, this.entrySize + this.max, true)));
        return this;
    }

    public InnerSpec entry(Object key, @Nullable Object value) {
        this.setEntry(key, value);
        return this;
    }

    public InnerSpec entry(Object key, Consumer<InnerSpec> consumer) {
        if (key == null) {
            throw new IllegalArgumentException("Map key cannot be null.");
        }
        if (consumer == null) {
            this.setEntry(key, null);
            return this;
        }
        ++this.entrySize;
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(true))), this.convertToNodeManipulator(key)));
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(false)));
        InnerSpec innerSpec = new InnerSpec(this.traverser, this.manipulateOptions, nextResolver);
        consumer.accept(innerSpec);
        this.arbitraryManipulators.addAll(innerSpec.arbitraryManipulators);
        this.containerInfoManipulators.addAll(innerSpec.containerInfoManipulators);
        return this;
    }

    public InnerSpec entry(Consumer<InnerSpec> consumer, @Nullable Object value) {
        ++this.entrySize;
        this.containerInfoManipulators.add(new ContainerInfoManipulator(this.treePathResolver, new ArbitraryContainerInfo(this.entrySize + this.min, this.entrySize + this.max, true)));
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(false))), this.convertToNodeManipulator(value)));
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(true)));
        InnerSpec innerSpec = new InnerSpec(this.traverser, this.manipulateOptions, nextResolver);
        consumer.accept(innerSpec);
        this.arbitraryManipulators.addAll(innerSpec.arbitraryManipulators);
        this.containerInfoManipulators.addAll(innerSpec.containerInfoManipulators);
        return this;
    }

    public InnerSpec listElement(int index, @Nullable Object value) {
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new ContainerElementPredicate(index)));
        NodeManipulator manipulator = this.convertToNodeManipulator(value);
        this.arbitraryManipulators.add(new ArbitraryManipulator(nextResolver, manipulator));
        return this;
    }

    public InnerSpec listElement(int index, Consumer<InnerSpec> consumer) {
        if (consumer == null) {
            return this.listElement(index, (Object)null);
        }
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new ContainerElementPredicate(index)));
        InnerSpec innerSpec = new InnerSpec(this.traverser, this.manipulateOptions, nextResolver);
        consumer.accept(innerSpec);
        this.arbitraryManipulators.addAll(innerSpec.arbitraryManipulators);
        this.containerInfoManipulators.addAll(innerSpec.containerInfoManipulators);
        return this;
    }

    public InnerSpec property(String property, @Nullable Object value) {
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new PropertyNameNodePredicate(property)));
        NodeManipulator manipulator = this.convertToNodeManipulator(value);
        this.arbitraryManipulators.add(new ArbitraryManipulator(nextResolver, manipulator));
        return this;
    }

    public InnerSpec property(String property, Consumer<InnerSpec> consumer) {
        if (consumer == null) {
            return this.property(property, (Object)null);
        }
        CompositeNodeResolver nextResolver = new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new PropertyNameNodePredicate(property)));
        InnerSpec innerSpec = new InnerSpec(this.traverser, this.manipulateOptions, nextResolver);
        consumer.accept(innerSpec);
        this.arbitraryManipulators.addAll(innerSpec.arbitraryManipulators);
        this.containerInfoManipulators.addAll(innerSpec.containerInfoManipulators);
        return this;
    }

    public InnerSpec keyLazy(Supplier<?> supplier) {
        ++this.entrySize;
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(supplier);
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(true))), this.convertToNodeManipulator(lazyArbitrary)));
        return this;
    }

    public InnerSpec valueLazy(Supplier<?> supplier) {
        ++this.entrySize;
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(supplier);
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(false))), this.convertToNodeManipulator(lazyArbitrary)));
        return this;
    }

    public InnerSpec entryLazy(Supplier<?> keySupplier, Supplier<?> valueSupplier) {
        ++this.entrySize;
        LazyArbitrary keyLazyArbitrary = LazyArbitrary.lazy(keySupplier);
        LazyArbitrary valueLazyArbitrary = LazyArbitrary.lazy(valueSupplier);
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(true))), this.convertToNodeManipulator(keyLazyArbitrary)));
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(false))), this.convertToNodeManipulator(valueLazyArbitrary)));
        return this;
    }

    public InnerSpec allKeyLazy(Supplier<?> supplier) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(supplier);
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeAllEntryPredicate()), new DefaultNodeResolver(new NodeKeyValuePredicate(true))), this.convertToNodeManipulator(lazyArbitrary)));
        return this;
    }

    public InnerSpec allValueLazy(Supplier<?> supplier) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(supplier);
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeAllEntryPredicate()), new DefaultNodeResolver(new NodeKeyValuePredicate(false))), this.convertToNodeManipulator(lazyArbitrary)));
        return this;
    }

    public InnerSpec allEntryLazy(Supplier<?> keySupplier, Supplier<?> valueSupplier) {
        LazyArbitrary keyLazyArbitrary = LazyArbitrary.lazy(keySupplier);
        LazyArbitrary valueLazyArbitrary = LazyArbitrary.lazy(valueSupplier);
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeAllEntryPredicate()), new DefaultNodeResolver(new NodeKeyValuePredicate(true))), this.convertToNodeManipulator(keyLazyArbitrary)));
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeAllEntryPredicate()), new DefaultNodeResolver(new NodeKeyValuePredicate(false))), this.convertToNodeManipulator(valueLazyArbitrary)));
        return this;
    }

    public List<ArbitraryManipulator> getArbitraryManipulators() {
        return this.arbitraryManipulators;
    }

    public List<ContainerInfoManipulator> getContainerInfoManipulators() {
        return this.containerInfoManipulators;
    }

    private void setValue(@Nullable Object value) {
        ++this.entrySize;
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(false))), this.convertToNodeManipulator(value)));
    }

    private void setEntry(Object key, @Nullable Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Map key cannot be null.");
        }
        ++this.entrySize;
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(true))), this.convertToNodeManipulator(key)));
        this.arbitraryManipulators.add(new ArbitraryManipulator(new CompositeNodeResolver(this.treePathResolver, new DefaultNodeResolver(new NodeEntryPredicate(this.entrySize - 1)), new DefaultNodeResolver(new NodeKeyValuePredicate(false))), this.convertToNodeManipulator(value)));
    }

    private NodeManipulator convertToNodeManipulator(@Nullable Object value) {
        if (value instanceof Arbitrary) {
            return new NodeSetLazyManipulator(this.traverser, this.manipulateOptions, LazyArbitrary.lazy(() -> ((Arbitrary)value).sample()), false);
        }
        if (value instanceof LazyArbitrary) {
            return new NodeSetLazyManipulator(this.traverser, this.manipulateOptions, (LazyArbitrary)value, false);
        }
        if (value == null) {
            return new NodeNullityManipulator(true);
        }
        return new NodeSetDecomposedValueManipulator<Object>(this.traverser, this.manipulateOptions, value, false);
    }
}

