/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.TypeSupports;
import com.navercorp.fixturemonkey.generator.AnnotatedGeneratorConstraint;
import com.navercorp.fixturemonkey.generator.AnnotationSource;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.arbitraries.LongArbitrary;

final class AnnotatedGeneratorConstraints {
    AnnotatedGeneratorConstraints() {
    }

    public static AnnotatedGeneratorConstraint findConstraintByClass(Class<?> clazz, AnnotationSource annotationSource) {
        if (TypeSupports.isNumberType(clazz)) {
            return AnnotatedGeneratorConstraints.findNumberConstraint(clazz, annotationSource);
        }
        if (String.class == clazz) {
            return AnnotatedGeneratorConstraints.findStringConstraint(clazz, annotationSource);
        }
        if (TypeSupports.isDateType(clazz)) {
            return AnnotatedGeneratorConstraints.findDateConstraint(clazz, annotationSource);
        }
        return AnnotatedGeneratorConstraint.builder().build();
    }

    public static LongArbitrary generateDateMillisArbitrary(AnnotatedGeneratorConstraint constraint) {
        Instant now = Instant.now();
        long range = 365L;
        ChronoUnit unit = ChronoUnit.DAYS;
        LongArbitrary dateArbitrary = Arbitraries.longs().between(now.minus(range, unit).toEpochMilli(), now.plus(range, unit).toEpochMilli());
        BigDecimal min = constraint.getMin();
        BigDecimal max = constraint.getMax();
        if (min != null && max != null) {
            dateArbitrary = dateArbitrary.between(min.longValue(), max.longValue());
        } else if (max != null) {
            dateArbitrary = dateArbitrary.lessOrEqual(max.longValue());
        } else if (min != null) {
            dateArbitrary = dateArbitrary.greaterOrEqual(min.longValue());
        }
        return dateArbitrary;
    }

    private static AnnotatedGeneratorConstraint findNumberConstraint(Class<?> clazz, AnnotationSource annotationSource) {
        Optional<DecimalMax> decimalMaxAnnotation;
        Optional<Max> maxAnnotation;
        Optional<DecimalMin> decimalMinAnnotation;
        Optional<Min> minAnnotation;
        BigDecimal min = null;
        BigDecimal max = null;
        boolean minInclusive = true;
        boolean maxInclusive = true;
        Optional<Digits> digitsAnnotation = annotationSource.findAnnotation(Digits.class);
        if (digitsAnnotation.isPresent()) {
            BigDecimal value = BigDecimal.ONE;
            int integer = digitsAnnotation.get().integer();
            if (integer > 1) {
                value = BigDecimal.TEN.pow(integer - 1);
            }
            max = value.multiply(BigDecimal.TEN).subtract(BigDecimal.valueOf(1L));
            min = max.negate();
        }
        if ((minAnnotation = annotationSource.findAnnotation(Min.class)).isPresent()) {
            BigDecimal minValue = minAnnotation.map(Min::value).map(BigDecimal::valueOf).get();
            if (min == null) {
                min = minValue;
            } else if (min.compareTo(minValue) > 0) {
                min = minValue;
            }
        }
        if ((decimalMinAnnotation = annotationSource.findAnnotation(DecimalMin.class)).isPresent()) {
            BigDecimal decimalMin = decimalMinAnnotation.map(DecimalMin::value).map(BigDecimal::new).get();
            if (min == null) {
                min = decimalMin;
            } else if (min.compareTo(decimalMin) < 0) {
                min = decimalMin;
            }
        }
        if ((maxAnnotation = annotationSource.findAnnotation(Max.class)).isPresent()) {
            BigDecimal maxValue = maxAnnotation.map(Max::value).map(BigDecimal::valueOf).get();
            if (max == null) {
                max = maxValue;
            } else if (max.compareTo(maxValue) > 0) {
                max = maxValue;
            }
        }
        if ((decimalMaxAnnotation = annotationSource.findAnnotation(DecimalMax.class)).isPresent()) {
            BigDecimal decimalMax = decimalMaxAnnotation.map(DecimalMax::value).map(BigDecimal::new).get();
            if (max == null) {
                max = decimalMax;
            } else if (max.compareTo(decimalMax) > 0) {
                max = decimalMax;
            }
        }
        if (annotationSource.findAnnotation(Negative.class).isPresent() && (max == null || max.compareTo(BigDecimal.valueOf(0L)) > 0)) {
            if (TypeSupports.isFloatType(clazz)) {
                max = BigDecimal.ZERO;
                maxInclusive = false;
            } else {
                max = BigDecimal.valueOf(-1L);
            }
        }
        if (annotationSource.findAnnotation(NegativeOrZero.class).isPresent() && (max == null || max.compareTo(BigDecimal.ZERO) > 0)) {
            max = BigDecimal.ZERO;
        }
        if (annotationSource.findAnnotation(Positive.class).isPresent() && (min == null || min.compareTo(BigDecimal.ZERO) < 0)) {
            if (TypeSupports.isFloatType(clazz)) {
                min = BigDecimal.ZERO;
                minInclusive = false;
            } else {
                min = BigDecimal.ONE;
            }
        }
        if (annotationSource.findAnnotation(PositiveOrZero.class).isPresent() && (min == null || min.compareTo(BigDecimal.ZERO) < 0)) {
            min = BigDecimal.ZERO;
        }
        return AnnotatedGeneratorConstraint.builder().min(min).max(max).maxInclusive(maxInclusive).minInclusive(minInclusive).build();
    }

    private static AnnotatedGeneratorConstraint findStringConstraint(Class<?> clazz, AnnotationSource annotationSource) {
        Optional<Size> size;
        BigDecimal min = null;
        BigDecimal max = null;
        if (annotationSource.findAnnotation(NotBlank.class).isPresent() || annotationSource.findAnnotation(NotEmpty.class).isPresent()) {
            min = BigDecimal.ONE;
        }
        if ((size = annotationSource.findAnnotation(Size.class)).isPresent()) {
            BigDecimal minValue = BigDecimal.valueOf(size.map(Size::min).get().intValue());
            if (min == null) {
                min = minValue;
            } else if (min.compareTo(minValue) < 0) {
                min = minValue;
            }
            max = BigDecimal.valueOf(size.map(Size::max).get().intValue());
        }
        return AnnotatedGeneratorConstraint.builder().max(max).min(min).build();
    }

    private static AnnotatedGeneratorConstraint findDateConstraint(Class<?> clazz, AnnotationSource annotationSource) {
        BigDecimal now = BigDecimal.valueOf(Instant.now().toEpochMilli());
        BigDecimal min = null;
        BigDecimal max = null;
        if (annotationSource.findAnnotation(Past.class).isPresent()) {
            max = now.subtract(BigDecimal.valueOf(1000L));
        }
        if (annotationSource.findAnnotation(PastOrPresent.class).isPresent()) {
            if (max == null) {
                max = now;
            } else if (max.compareTo(now) > 0) {
                max = now;
            }
        }
        if (annotationSource.findAnnotation(Future.class).isPresent()) {
            min = now.add(BigDecimal.valueOf(2000L));
        }
        if (annotationSource.findAnnotation(FutureOrPresent.class).isPresent()) {
            if (min == null) {
                min = now.add(BigDecimal.valueOf(2000L));
            } else if (min.compareTo(now) > 0) {
                min = now.add(BigDecimal.valueOf(2000L));
            }
        }
        return AnnotatedGeneratorConstraint.builder().min(min).max(max).build();
    }
}

