/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;

final class ArrayBuilder {
    public static ArrayBuilder INSTANCE = new ArrayBuilder();

    ArrayBuilder() {
    }

    public <T> Arbitrary<T> build(Class<T> clazz, List<ArbitraryNode> nodes) {
        Builders.BuilderCombinator builder = Builders.withBuilder(() -> new ArrayBuilderFrame(clazz, nodes.size()));
        if (nodes.isEmpty()) {
            return builder.build(ArrayBuilderFrame::build);
        }
        for (ArbitraryNode node : nodes) {
            builder = builder.use(node.getArbitrary()).in(ArrayBuilderFrame::add);
        }
        return builder.build(ArrayBuilderFrame::build);
    }

    private static final class ArrayBuilderFrame {
        private final List<Object> array = new ArrayList<Object>();
        private final Class<?> componentType;
        private final int size;

        public ArrayBuilderFrame(Class<?> componentType, int size) {
            this.componentType = componentType;
            this.size = size;
        }

        ArrayBuilderFrame add(Object value) {
            if (this.array.size() >= this.size) {
                return this;
            }
            this.array.add(value);
            return this;
        }

        Object build() {
            Object array = Array.newInstance(this.componentType, this.size);
            for (int i = 0; i < this.array.size(); ++i) {
                Array.set(array, i, this.array.get(i));
            }
            return array;
        }
    }
}

