/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizers;
import com.navercorp.fixturemonkey.customizer.WithFixtureCustomizer;
import com.navercorp.fixturemonkey.generator.AbstractArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.FieldArbitraries;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;

public final class BeanArbitraryGenerator
extends AbstractArbitraryGenerator
implements WithFixtureCustomizer {
    public static final BeanArbitraryGenerator INSTANCE = new BeanArbitraryGenerator();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ArbitraryCustomizers arbitraryCustomizers;
    private final PropertyNameResolver propertyNameResolver = PropertyNameResolver.IDENTITY;

    public BeanArbitraryGenerator() {
        this(new ArbitraryCustomizers());
    }

    private BeanArbitraryGenerator(ArbitraryCustomizers arbitraryCustomizers) {
        this.arbitraryCustomizers = arbitraryCustomizers;
    }

    @Override
    protected <T> Arbitrary<T> generateObject(ArbitraryType type, List<ArbitraryNode> nodes) {
        Class<?> clazz = type.getType();
        if (clazz.isInterface()) {
            return Arbitraries.just(null);
        }
        FieldArbitraries fieldArbitraries = new FieldArbitraries(this.toArbitrariesByFieldName(nodes, ArbitraryNode::getPropertyName, (node, arbitrary) -> arbitrary));
        this.arbitraryCustomizers.customizeFields(clazz, fieldArbitraries);
        Map<String, PropertyDescriptor> propertyDescriptorMap = this.getPropertyDescriptorsByName(clazz);
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> ReflectionUtils.newInstance((Class)clazz, (Object[])new Object[0]));
        for (Map.Entry<String, Arbitrary> entry : fieldArbitraries.entrySet()) {
            String fieldName = entry.getKey();
            PropertyDescriptor propertyDescriptor = propertyDescriptorMap.get(fieldName);
            if (propertyDescriptor == null || propertyDescriptor.getWriteMethod() == null) continue;
            Method writeMethod = propertyDescriptor.getWriteMethod();
            builderCombinator = builderCombinator.use(entry.getValue()).in((b, v) -> {
                try {
                    if (v != null) {
                        writeMethod.invoke(b, v);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.log.warn((Throwable)e, () -> "set bean property is failed. field: " + fieldName + " value: " + v);
                }
                return b;
            });
        }
        return builderCombinator.build(b -> this.arbitraryCustomizers.customizeFixture(clazz, b));
    }

    @Override
    public String resolveFieldName(Field field) {
        return this.propertyNameResolver.resolve((Property)new FieldProperty(field));
    }

    @Override
    public ArbitraryGenerator withFixtureCustomizers(ArbitraryCustomizers arbitraryCustomizers) {
        if (this.arbitraryCustomizers == arbitraryCustomizers) {
            return this;
        }
        return new BeanArbitraryGenerator(arbitraryCustomizers);
    }

    private Map<String, PropertyDescriptor> getPropertyDescriptorsByName(Class<?> clazz) {
        HashMap<String, PropertyDescriptor> result = new HashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                result.put(descriptor.getName(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            this.log.warn((Throwable)e, () -> "Introspect bean property is failed. type: " + clazz);
        }
        return result;
    }
}

