/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.generator.AnnotatedArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.AnnotatedGeneratorConstraint;
import com.navercorp.fixturemonkey.generator.AnnotatedGeneratorConstraints;
import com.navercorp.fixturemonkey.generator.AnnotationSource;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;

public class BigIntegerAnnotatedArbitraryGenerator
implements AnnotatedArbitraryGenerator<BigInteger> {
    public static final BigIntegerAnnotatedArbitraryGenerator INSTANCE = new BigIntegerAnnotatedArbitraryGenerator();

    @Override
    public Arbitrary<BigInteger> generate(AnnotationSource annotationSource) {
        AnnotatedGeneratorConstraint constraint = AnnotatedGeneratorConstraints.findConstraintByClass(BigInteger.class, annotationSource);
        return this.generate(constraint);
    }

    private BigIntegerArbitrary generate(AnnotatedGeneratorConstraint constraint) {
        BigIntegerArbitrary arbitrary = Arbitraries.bigIntegers();
        BigDecimal min = constraint.getMin();
        BigDecimal max = constraint.getMax();
        if (min != null && max != null) {
            return arbitrary.between(min.toBigInteger(), max.toBigInteger());
        }
        if (max != null) {
            return arbitrary.lessOrEqual(max.toBigInteger());
        }
        if (min != null) {
            return arbitrary.greaterOrEqual(min.toBigInteger());
        }
        return arbitrary;
    }
}

