/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizers;
import com.navercorp.fixturemonkey.generator.AbstractArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.BuilderFieldArbitraries;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.junit.platform.commons.util.ReflectionUtils;

public final class BuilderArbitraryGenerator
extends AbstractArbitraryGenerator {
    public static final BuilderArbitraryGenerator INSTANCE = new BuilderArbitraryGenerator();
    private static final Map<Class<?>, Method> BUILDER_CACHE = new ConcurrentHashMap();
    private static final Map<String, Method> BUILD_FIELD_METHOD_CACHE = new ConcurrentHashMap<String, Method>();
    private static final Map<Class<?>, Method> BUILD_METHOD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> BUILDER_TYPE_CACHE = new ConcurrentHashMap();
    private final ArbitraryCustomizers arbitraryCustomizers;
    private String defaultBuildMethodName = "build";
    private String defaultBuilderMethodName = "builder";
    private final Map<Class<?>, String> typedBuilderMethodName = new ConcurrentHashMap();
    private final Map<Class<?>, String> typedBuildMethodName = new ConcurrentHashMap();
    private final PropertyNameResolver propertyNameResolver = PropertyNameResolver.IDENTITY;

    public BuilderArbitraryGenerator() {
        this(new ArbitraryCustomizers());
    }

    private BuilderArbitraryGenerator(ArbitraryCustomizers arbitraryCustomizers) {
        this.arbitraryCustomizers = arbitraryCustomizers;
    }

    private static void clearMethodCache() {
        BUILDER_CACHE.clear();
        BUILD_FIELD_METHOD_CACHE.clear();
        BUILD_METHOD_CACHE.clear();
    }

    @Override
    public <T> Arbitrary<T> generateObject(ArbitraryType type, List<ArbitraryNode> nodes) {
        Map<String, Arbitrary> arbitraryMap = this.toArbitrariesByFieldName(nodes, ArbitraryNode::getPropertyName, (node, arbitrary) -> arbitrary);
        Class<?> clazz = type.getType();
        BuilderFieldArbitraries<?> fieldArbitraries = BuilderFieldArbitraries.withBuilderType(this.getBuilderType(clazz), arbitraryMap);
        this.arbitraryCustomizers.customizeFields(clazz, fieldArbitraries);
        this.arbitraryCustomizers.customizeBuilderFields(clazz, fieldArbitraries);
        Method builderMethod = BUILDER_CACHE.get(clazz);
        Class<?> builderType = this.getBuilderType(clazz);
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> ReflectionUtils.invokeMethod((Method)builderMethod, null, (Object[])new Object[0]));
        for (Map.Entry<String, Arbitrary> entry : fieldArbitraries.entrySet()) {
            String string = entry.getKey();
            String buildFieldMethodName = builderType.getName() + "#" + string;
            Method method = BUILD_FIELD_METHOD_CACHE.computeIfAbsent(buildFieldMethodName, f -> {
                Method buildFieldMethod = ReflectionUtils.findMethods((Class)builderType, m -> m.getName().equals(methodName)).stream().filter(Objects::nonNull).filter(m -> m.getParameterCount() == 1).findFirst().orElse(null);
                if (buildFieldMethod != null) {
                    buildFieldMethod.setAccessible(true);
                }
                return buildFieldMethod;
            });
            if (method == null) continue;
            builderCombinator = builderCombinator.use(entry.getValue()).in((b, v) -> v != null ? ReflectionUtils.invokeMethod((Method)method, (Object)b, (Object[])new Object[]{v}) : b);
        }
        List<Map.Entry<Arbitrary, BiFunction<?, ?, ?>>> chains = fieldArbitraries.getCombinationChainMapList();
        for (Map.Entry<Arbitrary, BiFunction<?, ?, ?>> entry : chains) {
            builderCombinator = builderCombinator.use(entry.getKey()).in(entry.getValue());
        }
        Method method = BUILD_METHOD_CACHE.computeIfAbsent(builderType, t -> {
            String buildMethodName = this.getBuildMethodName((Class<?>)t);
            Method method = (Method)ReflectionUtils.findMethod((Class)builderType, (String)buildMethodName, (Class[])new Class[0]).orElseThrow(() -> new IllegalStateException("Can not find BuilderCombiner build method for clazz. clazz: " + clazz));
            method.setAccessible(true);
            return method;
        });
        return builderCombinator.build(b -> {
            if ((b = this.arbitraryCustomizers.customizeBuilder(clazz, b)) == null) {
                return null;
            }
            Object fixture = ReflectionUtils.invokeMethod((Method)buildMethod, (Object)b, (Object[])new Object[0]);
            return this.arbitraryCustomizers.customizeFixture(clazz, fixture);
        });
    }

    private Class<?> getBuilderType(Class<?> objectType) {
        Method builderMethod = BUILDER_CACHE.computeIfAbsent(objectType, t -> {
            String builderMethodName = this.getBuilderMethodName((Class<?>)t);
            Method method = ReflectionUtils.findMethod((Class)t, (String)builderMethodName, (Class[])new Class[0]).orElse(null);
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        });
        if (builderMethod == null) {
            throw new IllegalArgumentException("Class has no builder class. " + objectType.getName());
        }
        return BUILDER_TYPE_CACHE.computeIfAbsent(objectType, t -> {
            Object builder = ReflectionUtils.invokeMethod((Method)builderMethod, null, (Object[])new Object[0]);
            return builder.getClass();
        });
    }

    public String getBuildMethodName(Class<?> type) {
        return this.typedBuildMethodName.getOrDefault(type, this.defaultBuildMethodName);
    }

    public String getBuilderMethodName(Class<?> type) {
        return this.typedBuilderMethodName.getOrDefault(type, this.defaultBuilderMethodName);
    }

    public void setDefaultBuilderMethodName(String defaultBuilderMethodName) {
        this.defaultBuilderMethodName = defaultBuilderMethodName;
        BuilderArbitraryGenerator.clearMethodCache();
    }

    public void setDefaultBuildMethodName(String defaultBuildMethodName) {
        this.defaultBuildMethodName = defaultBuildMethodName;
        BuilderArbitraryGenerator.clearMethodCache();
    }

    public void setBuilderMethodName(Class<?> type, String builderMethodName) {
        this.typedBuilderMethodName.put(type, builderMethodName);
        BuilderArbitraryGenerator.clearMethodCache();
    }

    public void setBuildMethodName(Class<?> type, String buildMethodName) {
        this.typedBuildMethodName.put(type, buildMethodName);
        BuilderArbitraryGenerator.clearMethodCache();
    }

    @Override
    public String resolveFieldName(Field field) {
        return this.propertyNameResolver.resolve((Property)new FieldProperty(field));
    }

    @Override
    public ArbitraryGenerator withFixtureCustomizers(ArbitraryCustomizers arbitraryCustomizers) {
        if (this.arbitraryCustomizers == arbitraryCustomizers) {
            return this;
        }
        return new BuilderArbitraryGenerator(arbitraryCustomizers);
    }
}

