/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNode;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryType;
import com.navercorp.fixturemonkey.customizer.ArbitraryCustomizers;
import com.navercorp.fixturemonkey.customizer.WithFixtureCustomizer;
import com.navercorp.fixturemonkey.generator.AbstractArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.FieldArbitraries;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Builders;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;

public final class FieldReflectionArbitraryGenerator
extends AbstractArbitraryGenerator
implements WithFixtureCustomizer {
    public static final FieldReflectionArbitraryGenerator INSTANCE = new FieldReflectionArbitraryGenerator();
    private static final Map<String, Field> TYPE_FIELD_CACHE = new ConcurrentHashMap<String, Field>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ArbitraryCustomizers arbitraryCustomizers;
    private final PropertyNameResolver propertyNameResolver = PropertyNameResolver.IDENTITY;

    public FieldReflectionArbitraryGenerator() {
        this(new ArbitraryCustomizers());
    }

    private FieldReflectionArbitraryGenerator(ArbitraryCustomizers arbitraryCustomizers) {
        this.arbitraryCustomizers = arbitraryCustomizers;
    }

    @Override
    protected <T> Arbitrary<T> generateObject(ArbitraryType type, List<ArbitraryNode> nodes) {
        Class<?> clazz = type.getType();
        if (clazz.isInterface()) {
            return Arbitraries.just(null);
        }
        FieldArbitraries fieldArbitraries = new FieldArbitraries(this.toArbitrariesByFieldName(nodes, ArbitraryNode::getPropertyName, (node, arbitrary) -> arbitrary));
        this.arbitraryCustomizers.customizeFields(clazz, fieldArbitraries);
        Builders.BuilderCombinator builderCombinator = Builders.withBuilder(() -> ReflectionUtils.newInstance((Class)clazz, (Object[])new Object[0]));
        for (Map.Entry<String, Arbitrary> entry : fieldArbitraries.entrySet()) {
            String fieldName = entry.getKey();
            String fieldKey = clazz.getName() + "#" + fieldName;
            Field field = TYPE_FIELD_CACHE.computeIfAbsent(fieldKey, k -> {
                List fields = ReflectionUtils.findFields((Class)clazz, f -> f.getName().equals(fieldName), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
                if (fields.isEmpty()) {
                    return null;
                }
                Field result = (Field)fields.get(0);
                result.setAccessible(true);
                return result;
            });
            if (field == null || Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            builderCombinator = builderCombinator.use(entry.getValue()).in((object, value) -> {
                try {
                    if (value != null) {
                        field.set(object, value);
                    }
                }
                catch (IllegalAccessException e) {
                    this.log.warn((Throwable)e, () -> "set field by reflection is failed. field: " + fieldName + " value: " + value);
                }
                return object;
            });
        }
        return builderCombinator.build(b -> this.arbitraryCustomizers.customizeFixture(clazz, b));
    }

    @Override
    public String resolveFieldName(Field field) {
        return this.propertyNameResolver.resolve((Property)new FieldProperty(field));
    }

    @Override
    public ArbitraryGenerator withFixtureCustomizers(ArbitraryCustomizers arbitraryCustomizers) {
        if (this.arbitraryCustomizers == arbitraryCustomizers) {
            return this;
        }
        return new FieldReflectionArbitraryGenerator(arbitraryCustomizers);
    }
}

