/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.navercorp.fixturemonkey.generator.AnnotatedArbitraryGenerator;
import com.navercorp.fixturemonkey.generator.AnnotatedGeneratorConstraint;
import com.navercorp.fixturemonkey.generator.AnnotatedGeneratorConstraints;
import com.navercorp.fixturemonkey.generator.AnnotationSource;
import java.math.BigDecimal;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;

public class FloatAnnotatedArbitraryGenerator
implements AnnotatedArbitraryGenerator<Float> {
    public static final FloatAnnotatedArbitraryGenerator INSTANCE = new FloatAnnotatedArbitraryGenerator();

    @Override
    public Arbitrary<Float> generate(AnnotationSource annotationSource) {
        AnnotatedGeneratorConstraint constraint = AnnotatedGeneratorConstraints.findConstraintByClass(Float.class, annotationSource);
        return this.generate(constraint);
    }

    private FloatArbitrary generate(AnnotatedGeneratorConstraint constraint) {
        FloatArbitrary arbitrary = Arbitraries.floats();
        BigDecimal min = constraint.getMin();
        BigDecimal max = constraint.getMax();
        if (min != null && max != null) {
            return arbitrary.between(min.floatValue(), max.floatValue());
        }
        if (max != null) {
            return arbitrary.lessOrEqual(max.floatValue());
        }
        if (min != null) {
            return arbitrary.greaterOrEqual(min.floatValue());
        }
        return arbitrary;
    }
}

