/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.generator;

import com.mifmif.common.regex.Generex;
import dk.brics.automaton.RegExp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;

final class RegexGenerator {
    private static final Map<String, String> PREDEFINED_CHARACTER_CLASSES;

    RegexGenerator() {
    }

    public List<String> generateAll(Pattern pattern) {
        return this.generateAll(pattern, null, null);
    }

    public List<String> generateAll(Pattern pattern, @Nullable Integer min, @Nullable Integer max) {
        RegExp regExp;
        String regex = pattern.regexp();
        for (Map.Entry<String, String> charClass : PREDEFINED_CHARACTER_CLASSES.entrySet()) {
            regex = regex.replaceAll(charClass.getKey(), charClass.getValue());
        }
        Pattern.Flag[] flags = pattern.flags();
        if (flags.length == 0) {
            regExp = new RegExp(regex);
        } else {
            int intFlag = 0;
            for (Pattern.Flag flag : flags) {
                intFlag |= flag.getValue();
            }
            regExp = new RegExp(regex, intFlag);
        }
        Generex generex = new Generex(regExp.toAutomaton());
        return this.generateAll(generex, min, max);
    }

    public List<String> generateAll(String regex) {
        return this.generateAll(regex, null, null);
    }

    public List<String> generateAll(String regex, @Nullable Integer min, @Nullable Integer max) {
        return this.generateAll(new Generex(regex), min, max);
    }

    private List<String> generateAll(Generex generex, @Nullable Integer min, @Nullable Integer max) {
        if (min == null) {
            min = 0;
        }
        if (max == null) {
            max = 255;
        }
        Integer regexMin = min;
        Integer regexMax = max;
        List<String> result = generex.getMatchedStrings(100).stream().filter(it -> it.length() >= regexMin && it.length() <= regexMax).collect(Collectors.toList());
        Collections.shuffle(result);
        return result;
    }

    static {
        HashMap<String, String> characterClasses = new HashMap<String, String>();
        characterClasses.put("\\\\d", "[0-9]");
        characterClasses.put("\\\\D", "[^0-9]");
        characterClasses.put("\\\\s", "[ \t\n\f\r]");
        characterClasses.put("\\\\S", "[^ \t\n\f\r]");
        characterClasses.put("\\\\w", "[a-zA-Z_0-9]");
        characterClasses.put("\\\\W", "[^a-zA-Z_0-9]");
        PREDEFINED_CHARACTER_CLASSES = Collections.unmodifiableMap(characterClasses);
    }
}

