/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.resolver.ArbitraryManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ArbitraryTree;
import com.navercorp.fixturemonkey.resolver.ArbitraryTreeMetadata;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.resolver.NextNodePredicate;
import com.navercorp.fixturemonkey.resolver.NodeResolver;
import com.navercorp.fixturemonkey.resolver.NodeSetLazyManipulator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ArbitraryResolver {
    private final ArbitraryTraverser traverser;
    private final ManipulatorOptimizer manipulatorOptimizer;
    private final GenerateOptions generateOptions;
    private final ManipulateOptions manipulateOptions;
    private final MonkeyContext monkeyContext;

    public ArbitraryResolver(ArbitraryTraverser traverser, ManipulatorOptimizer manipulatorOptimizer, GenerateOptions generateOptions, ManipulateOptions manipulateOptions, MonkeyContext monkeyContext) {
        this.traverser = traverser;
        this.manipulatorOptimizer = manipulatorOptimizer;
        this.generateOptions = generateOptions;
        this.manipulateOptions = manipulateOptions;
        this.monkeyContext = monkeyContext;
    }

    public Arbitrary<?> resolve(RootProperty rootProperty, List<ArbitraryManipulator> manipulators, List<MatcherOperator<? extends FixtureCustomizer>> customizers, List<ContainerInfoManipulator> containerInfoManipulators) {
        ArbitraryTree arbitraryTree = new ArbitraryTree(rootProperty, this.traverser.traverse((Property)rootProperty, containerInfoManipulators), this.generateOptions, this.monkeyContext, customizers);
        containerInfoManipulators.stream().flatMap(it -> it.getNodeResolver().resolve(arbitraryTree.findRoot()).stream()).forEach(it -> it.setManipulated(true));
        List<ArbitraryManipulator> registeredManipulators = this.getRegisteredToManipulators(this.manipulateOptions, arbitraryTree.getMetadata());
        List<ArbitraryManipulator> joinedManipulators = Stream.concat(registeredManipulators.stream(), manipulators.stream()).collect(Collectors.toList());
        List<ArbitraryManipulator> optimizedManipulator = this.manipulatorOptimizer.optimize(joinedManipulators).getManipulators();
        for (ArbitraryManipulator manipulator : optimizedManipulator) {
            manipulator.manipulate(arbitraryTree);
        }
        return arbitraryTree.generate();
    }

    private List<ArbitraryManipulator> getRegisteredToManipulators(ManipulateOptions manipulateOptions, ArbitraryTreeMetadata metadata) {
        ArrayList<ArbitraryManipulator> manipulators = new ArrayList<ArbitraryManipulator>();
        Map<Property, List<ArbitraryNode>> nodesByType = metadata.getNodesByProperty();
        List<MatcherOperator<ArbitraryBuilder<?>>> registeredArbitraryBuilders = manipulateOptions.getRegisteredArbitraryBuilders();
        for (Map.Entry<Property, List<ArbitraryNode>> nodeByType : nodesByType.entrySet()) {
            Property property = nodeByType.getKey();
            final List<ArbitraryNode> arbitraryNodes = nodeByType.getValue();
            ArbitraryBuilder registeredArbitraryBuilder = registeredArbitraryBuilders.stream().filter(it -> it.match(property)).findFirst().map(MatcherOperator::getOperator).orElse(null);
            if (registeredArbitraryBuilder == null) continue;
            LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(registeredArbitraryBuilder::sample);
            NodeSetLazyManipulator nodeManipulator = new NodeSetLazyManipulator(this.traverser, manipulateOptions, lazyArbitrary, false);
            manipulators.add(new ArbitraryManipulator(new NodeResolver(){

                @Override
                public List<ArbitraryNode> resolve(ArbitraryNode arbitraryNode) {
                    for (ArbitraryNode node : arbitraryNodes) {
                        node.setManipulated(true);
                    }
                    return arbitraryNodes;
                }

                @Override
                public List<NextNodePredicate> toNextNodePredicate() {
                    return Collections.emptyList();
                }
            }, arbitraryNode -> {
                nodeManipulator.manipulate(arbitraryNode);
                lazyArbitrary.clear();
            }));
        }
        return manipulators;
    }
}

