/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.ArbitraryTreeMetadata;
import com.navercorp.fixturemonkey.resolver.MetadataCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
final class ArbitraryTree {
    private final RootProperty rootProperty;
    private final ArbitraryNode rootNode;
    private final GenerateOptions generateOptions;
    private final ArbitraryTreeMetadata metadata;
    private final MonkeyContext monkeyContext;
    private final List<MatcherOperator<? extends FixtureCustomizer>> customizers;

    ArbitraryTree(RootProperty rootProperty, ArbitraryNode rootNode, GenerateOptions generateOptions, MonkeyContext monkeyContext, List<MatcherOperator<? extends FixtureCustomizer>> customizers) {
        this.rootProperty = rootProperty;
        this.rootNode = rootNode;
        this.generateOptions = generateOptions;
        this.monkeyContext = monkeyContext;
        this.customizers = customizers;
        MetadataCollector metadataCollector = new MetadataCollector(rootNode);
        this.metadata = metadataCollector.collect();
    }

    public ArbitraryTreeMetadata getMetadata() {
        return this.metadata;
    }

    ArbitraryNode findRoot() {
        return this.rootNode;
    }

    Arbitrary<?> generate() {
        ArbitraryGeneratorContext context = this.generateContext(this.rootNode, this.customizers, null);
        return this.generateArbitrary(context, this.rootNode);
    }

    private ArbitraryGeneratorContext generateContext(ArbitraryNode arbitraryNode, List<MatcherOperator<? extends FixtureCustomizer>> customizers, @Nullable ArbitraryGeneratorContext parentContext) {
        HashMap<ArbitraryProperty, ArbitraryNode> childNodesByArbitraryProperty = new HashMap<ArbitraryProperty, ArbitraryNode>();
        ArrayList<ArbitraryProperty> childrenProperties = new ArrayList<ArbitraryProperty>();
        for (ArbitraryNode childNode : arbitraryNode.getChildren()) {
            childNodesByArbitraryProperty.put(childNode.getArbitraryProperty(), childNode);
            childrenProperties.add(childNode.getArbitraryProperty());
        }
        ArrayList<MatcherOperator<? extends FixtureCustomizer>> arbitraryCustomizers = new ArrayList<MatcherOperator<? extends FixtureCustomizer>>();
        arbitraryCustomizers.addAll(this.generateOptions.getArbitraryCustomizers());
        arbitraryCustomizers.addAll(customizers);
        MonkeyGeneratorContext monkeyGeneratorContext = this.monkeyContext.retrieveGeneratorContext(this.rootProperty);
        return new ArbitraryGeneratorContext(arbitraryNode.getArbitraryProperty(), childrenProperties, parentContext, (ctx, prop) -> {
            ArbitraryNode node = (ArbitraryNode)childNodesByArbitraryProperty.get(prop);
            if (node == null) {
                return Arbitraries.just(null);
            }
            return this.generateArbitrary((ArbitraryGeneratorContext)ctx, node);
        }, arbitraryCustomizers, monkeyGeneratorContext);
    }

    private Arbitrary<?> generateArbitrary(ArbitraryGeneratorContext ctx, ArbitraryNode node) {
        Arbitrary generated;
        ArbitraryProperty prop = node.getArbitraryProperty();
        if (node.getArbitrary() != null) {
            generated = node.getArbitrary().injectNull(node.getArbitraryProperty().getObjectProperty().getNullInject());
        } else {
            ArbitraryGeneratorContext childArbitraryGeneratorContext = this.generateContext(node, this.customizers, ctx);
            Arbitrary cached = this.monkeyContext.getCachedArbitrary(node.getProperty());
            boolean notCustomized = ctx.getFixtureCustomizers().stream().noneMatch(it -> it.match(node.getProperty()));
            if (node.isNotManipulated() && notCustomized && cached != null) {
                generated = cached;
            } else {
                generated = this.generateOptions.getArbitraryGenerator(prop.getObjectProperty().getProperty()).generate(childArbitraryGeneratorContext);
                if (node.isNotManipulated() && notCustomized) {
                    this.monkeyContext.putCachedArbitrary(node.getProperty(), generated);
                }
            }
        }
        List<Predicate> arbitraryFilters = node.getArbitraryFilters();
        for (Predicate predicate : arbitraryFilters) {
            generated = generated.filter(predicate);
        }
        return generated.map(object -> ctx.getFixtureCustomizers().stream().filter(it -> it.match(node.getProperty())).map(MatcherOperator::getOperator).findFirst().map(it -> it.customizeFixture(object)).orElse(object));
    }
}

