/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpressionManipulator;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryNullity;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySet;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySetArbitrary;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySetLazyValue;
import com.navercorp.fixturemonkey.arbitrary.ArbitrarySetPostCondition;
import com.navercorp.fixturemonkey.arbitrary.BuilderManipulator;
import com.navercorp.fixturemonkey.arbitrary.ContainerSizeManipulator;
import com.navercorp.fixturemonkey.resolver.ApplyNodeCountManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.IdentityNodeResolver;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.NodeFilterManipulator;
import com.navercorp.fixturemonkey.resolver.NodeManipulator;
import com.navercorp.fixturemonkey.resolver.NodeNullityManipulator;
import com.navercorp.fixturemonkey.resolver.NodeResolver;
import com.navercorp.fixturemonkey.resolver.NodeSetDecomposedValueManipulator;
import com.navercorp.fixturemonkey.resolver.NodeSetLazyManipulator;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class BuilderManipulatorAdapter {
    private final ArbitraryTraverser traverser;
    private final ManipulateOptions manipulateOptions;

    public BuilderManipulatorAdapter(ArbitraryTraverser traverser, ManipulateOptions manipulateOptions) {
        this.traverser = traverser;
        this.manipulateOptions = manipulateOptions;
    }

    public ArbitraryManipulator convertToArbitraryManipulator(BuilderManipulator builderManipulator) {
        NodeResolver nodeResolver = this.getNodeResolver(builderManipulator);
        NodeManipulator nodeManipulator = this.getNodeManipulator(builderManipulator);
        return new ArbitraryManipulator(nodeResolver, nodeManipulator);
    }

    public ContainerInfoManipulator convertToContainerInfoManipulator(BuilderManipulator builderManipulator) {
        NodeResolver nodeResolver = this.getNodeResolver(builderManipulator);
        ArbitraryContainerInfo containerInfo = this.getContainerInfo(builderManipulator);
        return new ContainerInfoManipulator(nodeResolver, containerInfo);
    }

    private NodeResolver getNodeResolver(BuilderManipulator builderManipulator) {
        if (builderManipulator instanceof ArbitraryExpressionManipulator) {
            return ((ArbitraryExpressionManipulator)((Object)builderManipulator)).getArbitraryExpression().toNodeResolver();
        }
        return IdentityNodeResolver.INSTANCE;
    }

    private NodeManipulator getNodeManipulator(BuilderManipulator builderManipulator) {
        if (builderManipulator instanceof ArbitrarySet) {
            ArbitrarySet manipulator = (ArbitrarySet)builderManipulator;
            int limit = this.safeCast(manipulator.getLimit());
            return new ApplyNodeCountManipulator(new NodeSetDecomposedValueManipulator(this.traverser, this.manipulateOptions, manipulator.getApplicableValue(), false), limit);
        }
        if (builderManipulator instanceof ArbitrarySetArbitrary) {
            ArbitrarySetArbitrary manipulator = (ArbitrarySetArbitrary)builderManipulator;
            int limit = this.safeCast(manipulator.getLimit());
            return new ApplyNodeCountManipulator(new NodeSetLazyManipulator(this.traverser, this.manipulateOptions, LazyArbitrary.lazy(manipulator::getApplicableValue), false), limit);
        }
        if (builderManipulator instanceof ArbitrarySetLazyValue) {
            ArbitrarySetLazyValue manipulator = (ArbitrarySetLazyValue)builderManipulator;
            int limit = this.safeCast(manipulator.getLimit());
            return new ApplyNodeCountManipulator(new NodeSetLazyManipulator(this.traverser, this.manipulateOptions, LazyArbitrary.lazy(manipulator::getApplicableValue), false), limit);
        }
        if (builderManipulator instanceof ArbitrarySetPostCondition) {
            ArbitrarySetPostCondition manipulator = (ArbitrarySetPostCondition)builderManipulator;
            int limit = this.safeCast(manipulator.getLimit());
            return new ApplyNodeCountManipulator(new NodeFilterManipulator(manipulator.getClazz(), manipulator.getFilter()), limit);
        }
        if (builderManipulator instanceof ArbitraryNullity) {
            ArbitraryNullity manipulator = (ArbitraryNullity)builderManipulator;
            return new NodeNullityManipulator(manipulator.toNull());
        }
        throw new IllegalArgumentException("No convertable NodeManipulator exists : " + builderManipulator.getClass().getTypeName());
    }

    private ArbitraryContainerInfo getContainerInfo(BuilderManipulator builderManipulator) {
        if (builderManipulator instanceof ContainerSizeManipulator) {
            ContainerSizeManipulator manipulator = (ContainerSizeManipulator)builderManipulator;
            Integer min = manipulator.getMin();
            Integer max = manipulator.getMax();
            if (min == null && max != null) {
                min = Math.max(0, manipulator.getMax() - 3);
            } else if (min != null && max == null) {
                max = manipulator.getMin() + 3;
            }
            return new ArbitraryContainerInfo(min.intValue(), max.intValue(), true);
        }
        throw new IllegalArgumentException("BuilderManipulator not convertable to ArbitraryContainerInfo. BuilderManipulator type : " + builderManipulator.getClass().getTypeName());
    }

    private int safeCast(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Limit should be within the range of int type. limit : " + value);
        }
        return (int)value;
    }
}

