/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.resolver.NextNodePredicate;
import com.navercorp.fixturemonkey.resolver.NodeResolver;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ContainerInfoManipulator {
    private final NodeResolver nodeResolver;
    private ArbitraryContainerInfo containerInfo;

    public ContainerInfoManipulator(NodeResolver nodeResolver, ArbitraryContainerInfo containerInfo) {
        this.nodeResolver = nodeResolver;
        this.containerInfo = containerInfo;
    }

    public NodeResolver getNodeResolver() {
        return this.nodeResolver;
    }

    public ArbitraryContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public void fixed() {
        int fixedSize = this.containerInfo.getRandomSize();
        this.containerInfo = new ArbitraryContainerInfo(fixedSize, fixedSize, true);
    }

    public boolean isMatch(List<ArbitraryProperty> parentArbitraryProperties, ObjectProperty currentObjectProperty) {
        NextNodePredicate nextNodePredicate;
        int nextNodePredicateSize;
        List<NextNodePredicate> nextNodePredicates = this.nodeResolver.toNextNodePredicate();
        int parentArbitraryPropertySize = parentArbitraryProperties.size();
        if (parentArbitraryPropertySize + 1 != (nextNodePredicateSize = nextNodePredicates.size())) {
            return false;
        }
        for (int i = 0; i < parentArbitraryPropertySize; ++i) {
            ArbitraryProperty currentArbitraryProperty;
            ArbitraryProperty parentArbitraryProperty;
            nextNodePredicate = nextNodePredicates.get(i);
            if (nextNodePredicate.test(parentArbitraryProperty = i == 0 ? null : parentArbitraryProperties.get(i - 1), (currentArbitraryProperty = parentArbitraryProperties.get(i)).getObjectProperty(), currentArbitraryProperty.getContainerProperty())) continue;
            return false;
        }
        ArbitraryProperty parentArbitraryProperty = parentArbitraryPropertySize == 0 ? null : parentArbitraryProperties.get(parentArbitraryPropertySize - 1);
        nextNodePredicate = nextNodePredicates.get(nextNodePredicateSize - 1);
        return nextNodePredicate.test(parentArbitraryProperty, currentObjectProperty, null);
    }
}

