/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.NextNodePredicate;
import com.navercorp.fixturemonkey.resolver.NodeResolver;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public class DefaultNodeResolver
implements NodeResolver {
    private final NextNodePredicate nextNodePredicate;

    public DefaultNodeResolver(NextNodePredicate nextNodePredicate) {
        this.nextNodePredicate = nextNodePredicate;
    }

    @Override
    public List<ArbitraryNode> resolve(ArbitraryNode arbitraryNode) {
        List<ArbitraryNode> resolved = arbitraryNode.getChildren().stream().filter(it -> this.nextNodePredicate.test(arbitraryNode.getArbitraryProperty(), it.getArbitraryProperty().getObjectProperty(), it.getArbitraryProperty().getContainerProperty())).collect(Collectors.toList());
        arbitraryNode.setManipulated(true);
        arbitraryNode.setArbitraryProperty(arbitraryNode.getArbitraryProperty().withNullInject(0.0));
        for (ArbitraryNode node : resolved) {
            node.setManipulated(true);
            node.setArbitraryProperty(node.getArbitraryProperty().withNullInject(0.0));
        }
        return resolved;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNodeResolver that = (DefaultNodeResolver)obj;
        return this.nextNodePredicate.equals(that.nextNodePredicate);
    }

    public int hashCode() {
        return Objects.hash(this.nextNodePredicate);
    }

    @Override
    public List<NextNodePredicate> toNextNodePredicate() {
        return Collections.singletonList(this.nextNodePredicate);
    }
}

