/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.LabMonkey;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.arbitrary.ArbitraryExpressionFactory;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ApplyStrictModeResolver;
import com.navercorp.fixturemonkey.resolver.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.resolver.DefaultDecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ManipulateOptionsBuilder {
    private MonkeyExpressionFactory defaultMonkeyExpressionFactory;
    private boolean expressionStrictMode = false;
    private List<MatcherOperator<Function<LabMonkey, ? extends ArbitraryBuilder<?>>>> registeredArbitraryBuilders = new ArrayList();
    private List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredSampledArbitraryBuilders = new ArrayList();
    private DecomposedContainerValueFactory additionalDecomposedContainerValueFactory = null;
    private List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers;
    private PropertyNameResolver defaultPropertyNameResolver;

    ManipulateOptionsBuilder() {
    }

    public ManipulateOptionsBuilder expressionStrictMode(boolean expressionStrictMode) {
        this.expressionStrictMode = expressionStrictMode;
        return this;
    }

    public ManipulateOptionsBuilder monkeyExpressionFactory(MonkeyExpressionFactory monkeyExpressionFactory) {
        this.defaultMonkeyExpressionFactory = monkeyExpressionFactory;
        return this;
    }

    public ManipulateOptionsBuilder register(MatcherOperator<Function<LabMonkey, ? extends ArbitraryBuilder<?>>> arbitraryBuilderSupplier) {
        this.registeredArbitraryBuilders = ManipulateOptionsBuilder.insertFirst(this.registeredArbitraryBuilders, arbitraryBuilderSupplier);
        return this;
    }

    public ManipulateOptionsBuilder additionalDecomposedContainerValueFactory(DecomposedContainerValueFactory additionalDecomposedContainerValueFactory) {
        this.additionalDecomposedContainerValueFactory = additionalDecomposedContainerValueFactory;
        return this;
    }

    public ManipulateOptionsBuilder propertyNameResolvers(List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers) {
        this.propertyNameResolvers = propertyNameResolvers;
        return this;
    }

    public ManipulateOptionsBuilder defaultPropertyNameResolver(PropertyNameResolver defaultPropertyNameResolver) {
        this.defaultPropertyNameResolver = defaultPropertyNameResolver;
        return this;
    }

    public ManipulateOptions build() {
        this.defaultMonkeyExpressionFactory = ManipulateOptionsBuilder.defaultIfNull(this.defaultMonkeyExpressionFactory, ArbitraryExpressionFactory::new);
        if (this.expressionStrictMode) {
            MonkeyExpressionFactory currentMonkeyExpressionFactory = this.defaultMonkeyExpressionFactory;
            this.defaultMonkeyExpressionFactory = expression -> () -> new ApplyStrictModeResolver(currentMonkeyExpressionFactory.from(expression).toNodeResolver());
        }
        DefaultDecomposedContainerValueFactory decomposedContainerValueFactory = new DefaultDecomposedContainerValueFactory(this.additionalDecomposedContainerValueFactory);
        return new ManipulateOptions(this.defaultMonkeyExpressionFactory, this.registeredSampledArbitraryBuilders, decomposedContainerValueFactory, this.propertyNameResolvers, this.defaultPropertyNameResolver);
    }

    public void sampleRegisteredArbitraryBuilder(LabMonkey labMonkey) {
        for (MatcherOperator<Function<LabMonkey, ? extends ArbitraryBuilder<?>>> matcherOperator : this.registeredArbitraryBuilders) {
            this.registeredSampledArbitraryBuilders.add(new MatcherOperator(matcherOperator.getMatcher(), ((Function)matcherOperator.getOperator()).apply(labMonkey)));
        }
    }

    private static <T> T defaultIfNull(@Nullable T obj, Supplier<T> defaultValue) {
        return obj != null ? obj : defaultValue.get();
    }

    private static <T> List<T> insertFirst(List<T> list, T value) {
        ArrayList<T> result = new ArrayList<T>();
        result.add(value);
        result.addAll(list);
        return result;
    }
}

