/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.DecomposableContainerValue;
import com.navercorp.fixturemonkey.resolver.IdentityNodeResolver;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.NodeManipulator;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class NodeSetDecomposedValueManipulator<T>
implements NodeManipulator {
    private final ArbitraryTraverser traverser;
    private final ManipulateOptions manipulateOptions;
    @Nullable
    private final T value;
    private final boolean forced;

    public NodeSetDecomposedValueManipulator(ArbitraryTraverser traverser, ManipulateOptions manipulateOptions, @Nullable T value, boolean forced) {
        this.traverser = traverser;
        this.manipulateOptions = manipulateOptions;
        this.value = value;
        this.forced = forced;
    }

    @Override
    public void manipulate(ArbitraryNode arbitraryNode) {
        Class actualType = Types.getActualType((Type)arbitraryNode.getProperty().getType());
        if (this.value != null && !Types.isAssignable(this.value.getClass(), (Class)actualType)) {
            throw new IllegalArgumentException("The value is not of the same type as the property. node name: " + arbitraryNode.getArbitraryProperty().getObjectProperty().getResolvedPropertyName() + " node type: " + arbitraryNode.getProperty().getType().getTypeName() + " value type: " + this.value.getClass().getTypeName());
        }
        this.setValue(arbitraryNode, this.value);
    }

    private void setValue(ArbitraryNode arbitraryNode, @Nullable Object value) {
        ArbitraryProperty arbitraryProperty = arbitraryNode.getArbitraryProperty();
        arbitraryNode.setManipulated(true);
        arbitraryNode.setArbitraryProperty(arbitraryProperty.withNullInject(0.0));
        if (value == null) {
            arbitraryNode.setArbitraryProperty(arbitraryProperty.withNullInject(1.0));
            return;
        }
        ContainerProperty containerProperty = arbitraryProperty.getContainerProperty();
        if (containerProperty != null) {
            DecomposableContainerValue decomposableContainerValue = this.manipulateOptions.getDecomposedContainerValueFactory().from(value);
            value = decomposableContainerValue.getContainer();
            int decomposedContainerSize = decomposableContainerValue.getSize();
            if (this.forced || !containerProperty.getContainerInfo().isManipulated()) {
                ContainerInfoManipulator containerInfoManipulator = new ContainerInfoManipulator(IdentityNodeResolver.INSTANCE, new ArbitraryContainerInfo(decomposedContainerSize, decomposedContainerSize, false));
                ArbitraryNode newNode = this.traverser.traverse(arbitraryNode.getProperty(), Collections.singletonList(containerInfoManipulator));
                arbitraryNode.setArbitraryProperty(arbitraryNode.getArbitraryProperty().withContainerProperty(newNode.getArbitraryProperty().getContainerProperty()));
                arbitraryNode.setChildren(newNode.getChildren());
            }
            List<ArbitraryNode> children = arbitraryNode.getChildren();
            if (arbitraryProperty.getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
                decomposedContainerSize *= 2;
            }
            int decomposedNodeSize = Math.min(decomposedContainerSize, children.size());
            for (int i = 0; i < decomposedNodeSize; ++i) {
                ArbitraryNode child = children.get(i);
                Property childProperty = child.getProperty();
                this.setValue(child, childProperty.getValue(value));
            }
            return;
        }
        List<ArbitraryNode> children = arbitraryNode.getChildren();
        if (children.isEmpty()) {
            arbitraryNode.setArbitrary(Arbitraries.just((Object)value));
            return;
        }
        for (ArbitraryNode child : children) {
            Property childProperty = child.getProperty();
            this.setValue(child, childProperty.getValue(value));
        }
    }
}

