/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.NodeManipulator;
import com.navercorp.fixturemonkey.resolver.NodeNullityManipulator;
import com.navercorp.fixturemonkey.resolver.NodeSetDecomposedValueManipulator;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class NodeSetLazyManipulator<T>
implements NodeManipulator {
    private final ArbitraryTraverser traverser;
    private final ManipulateOptions manipulateOptions;
    private final LazyArbitrary<T> lazyArbitrary;
    private final boolean forced;

    public NodeSetLazyManipulator(ArbitraryTraverser traverser, ManipulateOptions manipulateOptions, LazyArbitrary<T> lazyArbitrary, boolean forced) {
        this.traverser = traverser;
        this.manipulateOptions = manipulateOptions;
        this.lazyArbitrary = lazyArbitrary;
        this.forced = forced;
    }

    @Override
    public void manipulate(ArbitraryNode arbitraryNode) {
        Object value = this.lazyArbitrary.getValue();
        if (value == null) {
            NodeNullityManipulator nullityManipulator = new NodeNullityManipulator(true);
            nullityManipulator.manipulate(arbitraryNode);
            return;
        }
        if (value instanceof Arbitrary) {
            value = ((Arbitrary)value).sample();
        }
        NodeSetDecomposedValueManipulator<Object> nodeSetDecomposedValueManipulator = new NodeSetDecomposedValueManipulator<Object>(this.traverser, this.manipulateOptions, value, this.forced);
        nodeSetDecomposedValueManipulator.manipulate(arbitraryNode);
        this.lazyArbitrary.clear();
    }
}

