/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.resolver.NextNodePredicate;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class PropertyNameNodePredicate
implements NextNodePredicate {
    private final String propertyName;

    public PropertyNameNodePredicate(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public boolean test(@Nullable ArbitraryProperty parentArbitraryProperty, ObjectProperty currentObjectProperty, @Nullable ContainerProperty currentContainerProperty) {
        String nodePropertyName = currentObjectProperty.getResolvedPropertyName();
        return "*".equals(this.propertyName) || this.propertyName.equals(nodePropertyName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyNameNodePredicate that = (PropertyNameNodePredicate)obj;
        return this.propertyName.equals(that.propertyName);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName);
    }
}

