/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.FixtureMonkey;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfoGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.InterfaceObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.NullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.NullObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.PropertyGenerator;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.CompositeArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.JavaArbitraryResolver;
import com.navercorp.fixturemonkey.api.introspector.JavaTimeArbitraryResolver;
import com.navercorp.fixturemonkey.api.introspector.JavaTimeTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.introspector.JavaTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.ExactTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.option.GenerateOptionsBuilder;
import com.navercorp.fixturemonkey.api.plugin.Plugin;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.DecomposableContainerValue;
import com.navercorp.fixturemonkey.resolver.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.ManipulateOptionsBuilder;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.resolver.NoneManipulatorOptimizer;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public class FixtureMonkeyBuilder {
    private final GenerateOptionsBuilder generateOptionsBuilder = GenerateOptions.builder();
    private final ManipulateOptionsBuilder manipulateOptionsBuilder = ManipulateOptions.builder();
    private ManipulatorOptimizer manipulatorOptimizer = new NoneManipulatorOptimizer();
    private DecomposedContainerValueFactory defaultDecomposedContainerValueFactory = obj -> {
        throw new IllegalArgumentException("given type is not supported container : " + obj.getClass().getTypeName());
    };
    private final Map<Class<?>, DecomposedContainerValueFactory> decomposableContainerFactoryMap = new HashMap();

    public FixtureMonkeyBuilder pushPropertyGenerator(MatcherOperator<PropertyGenerator> propertyGenerator) {
        this.generateOptionsBuilder.insertFirstPropertyGenerator(propertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypePropertyGenerator(Class<?> type, PropertyGenerator propertyGenerator) {
        this.generateOptionsBuilder.insertFirstPropertyGenerator(type, propertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypePropertyGenerator(Class<?> type, PropertyGenerator propertyGenerator) {
        this.generateOptionsBuilder.insertFirstPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, (Object)propertyGenerator));
        return this;
    }

    public FixtureMonkeyBuilder manipulatorOptimizer(ManipulatorOptimizer manipulatorOptimizer) {
        this.manipulatorOptimizer = manipulatorOptimizer;
        return this;
    }

    public FixtureMonkeyBuilder monkeyExpressionFactory(MonkeyExpressionFactory monkeyExpressionFactory) {
        this.manipulateOptionsBuilder.monkeyExpressionFactory(monkeyExpressionFactory);
        return this;
    }

    public FixtureMonkeyBuilder defaultObjectPropertyGenerator(ObjectPropertyGenerator objectPropertyGenerator) {
        this.generateOptionsBuilder.defaultObjectPropertyGenerator(objectPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeObjectPropertyGenerator(Class<?> type, ObjectPropertyGenerator objectPropertyGenerator) {
        this.generateOptionsBuilder.insertFirstArbitraryObjectPropertyGenerator(type, objectPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeObjectPropertyGenerator(Class<?> type, ObjectPropertyGenerator objectPropertyGenerator) {
        this.generateOptionsBuilder.insertFirstArbitraryObjectPropertyGenerator(MatcherOperator.exactTypeMatchOperator(type, (Object)objectPropertyGenerator));
        return this;
    }

    public FixtureMonkeyBuilder pushObjectPropertyGenerator(MatcherOperator<ObjectPropertyGenerator> objectPropertyGenerator) {
        this.generateOptionsBuilder.insertFirstArbitraryObjectPropertyGenerator(objectPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeContainerPropertyGenerator(Class<?> type, ContainerPropertyGenerator containerPropertyGenerator) {
        this.generateOptionsBuilder.insertFirstArbitraryContainerPropertyGenerator(type, containerPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeContainerPropertyGenerator(Class<?> type, ContainerPropertyGenerator containerPropertyGenerator) {
        this.generateOptionsBuilder.insertFirstArbitraryContainerPropertyGenerator(MatcherOperator.exactTypeMatchOperator(type, (Object)containerPropertyGenerator));
        return this;
    }

    public FixtureMonkeyBuilder pushContainerPropertyGenerator(MatcherOperator<ContainerPropertyGenerator> containerPropertyGenerator) {
        this.generateOptionsBuilder.insertFirstArbitraryContainerPropertyGenerator(containerPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypePropertyNameResolver(Class<?> type, PropertyNameResolver propertyNameResolver) {
        this.generateOptionsBuilder.insertFirstPropertyNameResolver(type, propertyNameResolver);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypePropertyNameResolver(Class<?> type, PropertyNameResolver propertyNameResolver) {
        this.generateOptionsBuilder.insertFirstPropertyNameResolver(MatcherOperator.exactTypeMatchOperator(type, (Object)propertyNameResolver));
        return this;
    }

    public FixtureMonkeyBuilder pushPropertyNameResolver(MatcherOperator<PropertyNameResolver> propertyNameResolver) {
        this.generateOptionsBuilder.insertFirstPropertyNameResolver(propertyNameResolver);
        return this;
    }

    public FixtureMonkeyBuilder defaultPropertyNameResolver(PropertyNameResolver propertyNameResolver) {
        this.generateOptionsBuilder.defaultPropertyNameResolver(propertyNameResolver);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeNullInjectGenerator(Class<?> type, NullInjectGenerator nullInjectGenerator) {
        this.generateOptionsBuilder.insertFirstNullInjectGenerators(MatcherOperator.exactTypeMatchOperator(type, (Object)nullInjectGenerator));
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeNullInjectGenerator(Class<?> type, NullInjectGenerator nullInjectGenerator) {
        this.generateOptionsBuilder.insertFirstNullInjectGenerators(type, nullInjectGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushNullInjectGenerator(MatcherOperator<NullInjectGenerator> nullInjectGenerator) {
        this.generateOptionsBuilder.insertFirstNullInjectGenerators(nullInjectGenerator);
        return this;
    }

    public FixtureMonkeyBuilder defaultNullInjectGenerator(NullInjectGenerator nullInjectGenerator) {
        this.generateOptionsBuilder.defaultNullInjectGenerator(nullInjectGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushArbitraryContainerInfoGenerator(MatcherOperator<ArbitraryContainerInfoGenerator> arbitraryContainerInfoGenerator) {
        this.generateOptionsBuilder.insertFirstArbitraryContainerInfoGenerator(arbitraryContainerInfoGenerator);
        return this;
    }

    public FixtureMonkeyBuilder defaultArbitraryContainerInfoGenerator(ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator) {
        this.generateOptionsBuilder.defaultArbitraryContainerInfoGenerator(defaultArbitraryContainerInfoGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeArbitraryIntrospector(Class<?> type, ArbitraryIntrospector arbitraryIntrospector) {
        this.generateOptionsBuilder.insertFirstArbitraryIntrospector(type, arbitraryIntrospector);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeArbitraryIntrospector(Class<?> type, ArbitraryIntrospector arbitraryIntrospector) {
        this.generateOptionsBuilder.insertFirstArbitraryIntrospector(MatcherOperator.exactTypeMatchOperator(type, (Object)arbitraryIntrospector));
        return this;
    }

    public FixtureMonkeyBuilder pushArbitraryIntrospector(MatcherOperator<ArbitraryIntrospector> arbitraryIntrospector) {
        this.generateOptionsBuilder.insertFirstArbitraryIntrospector(arbitraryIntrospector);
        return this;
    }

    public FixtureMonkeyBuilder objectIntrospector(ArbitraryIntrospector objectIntrospector) {
        this.generateOptionsBuilder.objectIntrospector(it -> objectIntrospector);
        return this;
    }

    public FixtureMonkeyBuilder javaTypeArbitraryGenerator(JavaTypeArbitraryGenerator javaTypeArbitraryGenerator) {
        this.generateOptionsBuilder.javaTypeArbitraryGenerator(javaTypeArbitraryGenerator);
        return this;
    }

    public FixtureMonkeyBuilder javaArbitraryResolver(JavaArbitraryResolver javaArbitraryResolver) {
        this.generateOptionsBuilder.javaArbitraryResolver(javaArbitraryResolver);
        return this;
    }

    public FixtureMonkeyBuilder javaTimeTypeArbitraryGenerator(JavaTimeTypeArbitraryGenerator javaTimeTypeArbitraryGenerator) {
        this.generateOptionsBuilder.javaTimeTypeArbitraryGenerator(javaTimeTypeArbitraryGenerator);
        return this;
    }

    public FixtureMonkeyBuilder javaTimeArbitraryResolver(JavaTimeArbitraryResolver javaTimeArbitraryResolver) {
        this.generateOptionsBuilder.javaTimeArbitraryResolver(javaTimeArbitraryResolver);
        return this;
    }

    public FixtureMonkeyBuilder arbitraryValidator(ArbitraryValidator arbitraryValidator) {
        this.generateOptionsBuilder.defaultArbitraryValidator(arbitraryValidator);
        return this;
    }

    public FixtureMonkeyBuilder pushExceptGenerateType(Matcher matcher) {
        this.generateOptionsBuilder.insertFirstArbitraryObjectPropertyGenerator(new MatcherOperator(matcher, (Object)NullObjectPropertyGenerator.INSTANCE));
        return this;
    }

    public FixtureMonkeyBuilder addExceptGenerateClass(Class<?> type) {
        return this.pushExceptGenerateType((Matcher)new AssignableTypeMatcher(type));
    }

    public FixtureMonkeyBuilder addExceptGenerateClasses(Class<?> ... types) {
        for (Class<?> type : types) {
            this.addExceptGenerateClass(type);
        }
        return this;
    }

    public FixtureMonkeyBuilder addExceptGeneratePackage(String exceptGeneratePackage) {
        return this.pushExceptGenerateType(property -> Types.primitiveToWrapper((Class)Types.getActualType((Type)property.getType())).getPackage().getName().startsWith(exceptGeneratePackage));
    }

    public FixtureMonkeyBuilder addExceptGeneratePackages(String ... exceptGeneratePackages) {
        for (String exceptGeneratePackage : exceptGeneratePackages) {
            this.addExceptGeneratePackage(exceptGeneratePackage);
        }
        return this;
    }

    public FixtureMonkeyBuilder register(Class<?> type, Function<FixtureMonkey, ? extends ArbitraryBuilder<?>> registeredArbitraryBuilder) {
        this.manipulateOptionsBuilder.register(MatcherOperator.assignableTypeMatchOperator(type, registeredArbitraryBuilder));
        return this;
    }

    public FixtureMonkeyBuilder registerExactType(Class<?> type, Function<FixtureMonkey, ? extends ArbitraryBuilder<?>> registeredArbitraryBuilder) {
        this.manipulateOptionsBuilder.register(MatcherOperator.exactTypeMatchOperator(type, registeredArbitraryBuilder));
        return this;
    }

    public FixtureMonkeyBuilder registerAssignableType(Class<?> type, Function<FixtureMonkey, ? extends ArbitraryBuilder<?>> registeredArbitraryBuilder) {
        this.manipulateOptionsBuilder.register(MatcherOperator.assignableTypeMatchOperator(type, registeredArbitraryBuilder));
        return this;
    }

    public FixtureMonkeyBuilder register(MatcherOperator<Function<FixtureMonkey, ? extends ArbitraryBuilder<?>>> registeredArbitraryBuilder) {
        this.manipulateOptionsBuilder.register(registeredArbitraryBuilder);
        return this;
    }

    public FixtureMonkeyBuilder registerGroup(Class<?> ... arbitraryBuilderGroups) {
        for (Class<?> arbitraryBuilderGroup : arbitraryBuilderGroups) {
            Method[] methods;
            for (Method method : methods = arbitraryBuilderGroup.getMethods()) {
                int paramCount = method.getParameterCount();
                Class<?> returnType = method.getReturnType();
                if (paramCount != 1 || !ArbitraryBuilder.class.isAssignableFrom(returnType)) continue;
                try {
                    Class actualType = Types.getActualType((AnnotatedType)((AnnotatedType)Types.getGenericsTypes((AnnotatedType)method.getAnnotatedReturnType()).get(0)));
                    Object noArgsInstance = arbitraryBuilderGroup.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Function<FixtureMonkey, ArbitraryBuilder> registerArbitraryBuilder = fixtureMonkey -> {
                        try {
                            return (ArbitraryBuilder)method.invoke(noArgsInstance, fixtureMonkey);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    };
                    this.register(actualType, registerArbitraryBuilder);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public FixtureMonkeyBuilder pushFixtureCustomizer(MatcherOperator<FixtureCustomizer> arbitraryCustomizer) {
        this.generateOptionsBuilder.insertFirstFixtureCustomizer(arbitraryCustomizer);
        return this;
    }

    public <T> FixtureMonkeyBuilder pushAssignableTypeFixtureCustomizer(Class<T> type, FixtureCustomizer<? extends T> fixtureCustomizer) {
        this.generateOptionsBuilder.insertFirstFixtureCustomizer(type, fixtureCustomizer);
        return this;
    }

    public <T> FixtureMonkeyBuilder pushExactTypeFixtureCustomizer(Class<T> type, FixtureCustomizer<T> fixtureCustomizer) {
        this.generateOptionsBuilder.insertFirstFixtureCustomizer(MatcherOperator.exactTypeMatchOperator(type, fixtureCustomizer));
        return this;
    }

    public FixtureMonkeyBuilder plugin(Plugin plugin) {
        this.generateOptionsBuilder.plugin(plugin);
        return this;
    }

    public FixtureMonkeyBuilder defaultDecomposedContainerValueFactory(DecomposedContainerValueFactory defaultDecomposedContainerValueFactory) {
        this.defaultDecomposedContainerValueFactory = defaultDecomposedContainerValueFactory;
        return this;
    }

    public FixtureMonkeyBuilder pushContainerIntrospector(ArbitraryIntrospector containerIntrospector) {
        this.generateOptionsBuilder.containerIntrospector(it -> new CompositeArbitraryIntrospector(Arrays.asList(containerIntrospector, it)));
        return this;
    }

    public FixtureMonkeyBuilder addContainerType(Class<?> type, ContainerPropertyGenerator containerObjectPropertyGenerator, ArbitraryIntrospector containerArbitraryIntrospector, DecomposedContainerValueFactory decomposedContainerValueFactory) {
        this.pushAssignableTypeContainerPropertyGenerator(type, containerObjectPropertyGenerator);
        this.pushContainerIntrospector(containerArbitraryIntrospector);
        this.decomposableContainerFactoryMap.put(type, decomposedContainerValueFactory);
        return this;
    }

    public FixtureMonkeyBuilder defaultPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.generateOptionsBuilder.defaultPropertyGenerator(propertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder defaultNotNull(boolean defaultNotNull) {
        this.generateOptionsBuilder.defaultNotNull(defaultNotNull);
        return this;
    }

    public FixtureMonkeyBuilder nullableContainer(boolean nullableContainer) {
        this.generateOptionsBuilder.nullableContainer(nullableContainer);
        return this;
    }

    public FixtureMonkeyBuilder nullableElement(boolean nullableElement) {
        this.generateOptionsBuilder.nullableElement(nullableElement);
        return this;
    }

    public <T> FixtureMonkeyBuilder interfaceImplements(Matcher matcher, List<Class<? extends T>> implementations) {
        this.pushObjectPropertyGenerator((MatcherOperator<ObjectPropertyGenerator>)new MatcherOperator(matcher, (Object)new InterfaceObjectPropertyGenerator(implementations)));
        return this;
    }

    public <T> FixtureMonkeyBuilder interfaceImplements(Class<T> interfaceClass, List<Class<? extends T>> implementations) {
        if (!Modifier.isAbstract(interfaceClass.getModifiers())) {
            throw new IllegalArgumentException("interfaceImplements option first parameter should be interface or abstract class. " + interfaceClass.getTypeName());
        }
        return this.interfaceImplements((Matcher)new ExactTypeMatcher(interfaceClass), implementations);
    }

    public FixtureMonkey build() {
        this.manipulateOptionsBuilder.additionalDecomposedContainerValueFactory(obj -> {
            Class<?> actualType = obj.getClass();
            for (Map.Entry<Class<?>, DecomposedContainerValueFactory> entry : this.decomposableContainerFactoryMap.entrySet()) {
                Class<?> type = entry.getKey();
                DecomposableContainerValue decomposedValue = entry.getValue().from(obj);
                if (!actualType.isAssignableFrom(type)) continue;
                return decomposedValue;
            }
            return this.defaultDecomposedContainerValueFactory.from(obj);
        });
        GenerateOptions generateOptions = this.generateOptionsBuilder.build();
        ArbitraryTraverser traverser = new ArbitraryTraverser(generateOptions);
        return new FixtureMonkey(generateOptions, this.manipulateOptionsBuilder, traverser, this.manipulatorOptimizer, generateOptions.getDefaultArbitraryValidator(), MonkeyContext.builder().build());
    }

    public FixtureMonkeyBuilder useExpressionStrictMode() {
        this.manipulateOptionsBuilder.expressionStrictMode(true);
        return this;
    }
}

