/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.customizer.InnerSpecState;
import com.navercorp.fixturemonkey.customizer.ManipulatorSet;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ApplyNodeCountManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.NodeFilterManipulator;
import com.navercorp.fixturemonkey.resolver.NodeManipulator;
import com.navercorp.fixturemonkey.resolver.NodeNullityManipulator;
import com.navercorp.fixturemonkey.resolver.NodeSetDecomposedValueManipulator;
import com.navercorp.fixturemonkey.resolver.NodeSetLazyManipulator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.10", status=API.Status.EXPERIMENTAL)
public final class MonkeyManipulatorFactory {
    public static final Object NOT_NULL = new Object();
    private final AtomicInteger sequence;
    private final MonkeyExpressionFactory monkeyExpressionFactory;
    private final ArbitraryTraverser traverser;
    private final ManipulateOptions manipulateOptions;

    public MonkeyManipulatorFactory(AtomicInteger sequence, ArbitraryTraverser traverser, ManipulateOptions manipulateOptions) {
        this.sequence = sequence;
        this.monkeyExpressionFactory = manipulateOptions.getDefaultMonkeyExpressionFactory();
        this.traverser = traverser;
        this.manipulateOptions = manipulateOptions;
    }

    public ArbitraryManipulator newArbitraryManipulator(String expression, @Nullable Object value, int limit) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), this.convertToNodeManipulator(value, limit));
    }

    public ArbitraryManipulator newArbitraryManipulator(String expression, @Nullable Object value) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), this.convertToNodeManipulator(this.sequence.getAndIncrement(), value));
    }

    public <T> ArbitraryManipulator newArbitraryManipulator(String expression, Class<T> type, Predicate<T> filter, int limit) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), new ApplyNodeCountManipulator(new NodeFilterManipulator(type, filter), limit));
    }

    public ArbitraryManipulator newNotNullArbitraryManipulator(String expression) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), new NodeNullityManipulator(false));
    }

    public ContainerInfoManipulator newContainerInfoManipulator(String expression, int min, int max) {
        int newSequence = this.sequence.getAndIncrement();
        return new ContainerInfoManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver().toNextNodePredicate(), new ArbitraryContainerInfo(min, max, Integer.valueOf(newSequence)));
    }

    public MonkeyManipulatorFactory copy() {
        return new MonkeyManipulatorFactory(new AtomicInteger(this.sequence.get()), this.traverser, this.manipulateOptions);
    }

    ManipulatorSet newManipulatorSet(InnerSpecState.ManipulatorHolderSet manipulatorHolderSet) {
        int baseSequence = this.sequence.getAndIncrement();
        ArrayList<ArbitraryManipulator> arbitraryManipulators = new ArrayList<ArbitraryManipulator>();
        List setArbitraryManipulators = manipulatorHolderSet.getNodeResolverObjectHolders().stream().map(it -> new ArbitraryManipulator(it.getNodeResolver(), this.convertToNodeManipulator(baseSequence + it.getSequence(), it.getValue()))).collect(Collectors.toList());
        List filterArbitraryManipulators = manipulatorHolderSet.getPostConditionManipulators().stream().map(it -> new ArbitraryManipulator(it.getNodeResolver(), new NodeFilterManipulator(it.getType(), it.getPredicate()))).collect(Collectors.toList());
        arbitraryManipulators.addAll(setArbitraryManipulators);
        arbitraryManipulators.addAll(filterArbitraryManipulators);
        List<ContainerInfoManipulator> containerInfoManipulators = manipulatorHolderSet.getContainerInfoManipulators().stream().map(it -> new ContainerInfoManipulator(it.getNodeResolver().toNextNodePredicate(), new ArbitraryContainerInfo(it.getElementMinSize(), it.getElementMaxSize(), Integer.valueOf(baseSequence + it.getSequence())))).collect(Collectors.toList());
        this.sequence.set(this.sequence.get() + containerInfoManipulators.size() + arbitraryManipulators.size());
        return new ManipulatorSet(arbitraryManipulators, containerInfoManipulators);
    }

    private NodeManipulator convertToNodeManipulator(@Nullable Object value, int limit) {
        NodeManipulator nodeManipulator = this.convertToNodeManipulator(this.sequence.getAndIncrement(), value);
        return new ApplyNodeCountManipulator(nodeManipulator, limit);
    }

    private NodeManipulator convertToNodeManipulator(int sequence, @Nullable Object value) {
        if (value == null) {
            return new NodeNullityManipulator(true);
        }
        if (value == NOT_NULL) {
            return new NodeNullityManipulator(false);
        }
        if (value instanceof Arbitrary) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.manipulateOptions, LazyArbitrary.lazy(() -> ((Arbitrary)value).sample()));
        }
        if (value instanceof DefaultArbitraryBuilder) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.manipulateOptions, LazyArbitrary.lazy(() -> ((DefaultArbitraryBuilder)value).sample()));
        }
        if (value instanceof Supplier) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.manipulateOptions, LazyArbitrary.lazy((Supplier)((Supplier)value)));
        }
        if (value instanceof LazyArbitrary) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.manipulateOptions, (LazyArbitrary)value);
        }
        return new NodeSetDecomposedValueManipulator<Object>(sequence, this.traverser, this.manipulateOptions, value);
    }
}

