/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
final class ArbitraryNode {
    @Nullable
    private final Property resolvedParentProperty;
    private ArbitraryProperty arbitraryProperty;
    private List<ArbitraryNode> children;
    @Nullable
    private Arbitrary<?> arbitrary;
    private boolean manipulated = false;
    private final List<Predicate> arbitraryFilters = new ArrayList<Predicate>();

    ArbitraryNode(@Nullable Property resolvedParentProperty, ArbitraryProperty arbitraryProperty, List<ArbitraryNode> children) {
        this.resolvedParentProperty = resolvedParentProperty;
        this.arbitraryProperty = arbitraryProperty;
        this.children = children;
    }

    public void setArbitraryProperty(ArbitraryProperty arbitraryProperty) {
        this.arbitraryProperty = arbitraryProperty;
    }

    public void setChildren(List<ArbitraryNode> children) {
        this.children = children;
    }

    @Nullable
    public Property getResolvedParentProperty() {
        return this.resolvedParentProperty;
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.arbitraryProperty;
    }

    public Property getProperty() {
        return this.getArbitraryProperty().getObjectProperty().getProperty();
    }

    public List<ArbitraryNode> getChildren() {
        return this.children;
    }

    @Nullable
    public Arbitrary<?> getArbitrary() {
        return this.arbitrary;
    }

    public void setArbitrary(@Nullable Arbitrary<?> arbitrary) {
        this.arbitrary = arbitrary;
    }

    public void addArbitraryFilter(Predicate filter) {
        this.arbitraryFilters.add(filter);
    }

    public List<Predicate> getArbitraryFilters() {
        return this.arbitraryFilters;
    }

    public boolean isNotManipulated() {
        boolean sized = this.arbitraryProperty.getContainerProperty() != null && this.arbitraryProperty.getContainerProperty().getContainerInfo().isManipulated();
        return !this.manipulated && !sized;
    }

    public void setManipulated(boolean manipulated) {
        this.manipulated = manipulated;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryNode that = (ArbitraryNode)obj;
        return Objects.equals(this.resolvedParentProperty, that.resolvedParentProperty) && this.arbitraryProperty.equals((Object)that.arbitraryProperty) && this.children.equals(that.children) && Objects.equals(this.arbitrary, that.arbitrary) && this.arbitraryFilters.equals(that.arbitraryFilters);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedParentProperty, this.arbitraryProperty, this.children, this.arbitrary, this.arbitraryFilters);
    }
}

