/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.resolver.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.resolver.ArbitraryManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ArbitraryTree;
import com.navercorp.fixturemonkey.resolver.ArbitraryTreeMetadata;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.resolver.NextNodePredicate;
import com.navercorp.fixturemonkey.resolver.NodeResolver;
import com.navercorp.fixturemonkey.resolver.PropertyPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ArbitraryResolver {
    private final ArbitraryTraverser traverser;
    private final ManipulatorOptimizer manipulatorOptimizer;
    private final GenerateOptions generateOptions;
    private final ManipulateOptions manipulateOptions;
    private final MonkeyContext monkeyContext;

    public ArbitraryResolver(ArbitraryTraverser traverser, ManipulatorOptimizer manipulatorOptimizer, GenerateOptions generateOptions, ManipulateOptions manipulateOptions, MonkeyContext monkeyContext) {
        this.traverser = traverser;
        this.manipulatorOptimizer = manipulatorOptimizer;
        this.generateOptions = generateOptions;
        this.manipulateOptions = manipulateOptions;
        this.monkeyContext = monkeyContext;
    }

    public Arbitrary<?> resolve(RootProperty rootProperty, List<ArbitraryManipulator> manipulators, List<MatcherOperator<? extends FixtureCustomizer>> customizers, List<ContainerInfoManipulator> containerInfoManipulators) {
        ArbitraryTree arbitraryTree = new ArbitraryTree(rootProperty, this.traverser.traverse((Property)rootProperty, containerInfoManipulators, this.manipulateOptions.getRegisteredArbitraryBuilders()), this.generateOptions, this.monkeyContext, customizers);
        List<ArbitraryManipulator> registeredManipulators = this.getRegisteredToManipulators(this.manipulateOptions, arbitraryTree.getMetadata());
        List<ArbitraryManipulator> joinedManipulators = Stream.concat(registeredManipulators.stream(), manipulators.stream()).collect(Collectors.toList());
        List<ArbitraryManipulator> optimizedManipulator = this.manipulatorOptimizer.optimize(joinedManipulators).getManipulators();
        for (ArbitraryManipulator manipulator : optimizedManipulator) {
            manipulator.manipulate(arbitraryTree);
        }
        return arbitraryTree.generate();
    }

    private List<ArbitraryManipulator> getRegisteredToManipulators(ManipulateOptions manipulateOptions, ArbitraryTreeMetadata metadata) {
        ArrayList<ArbitraryManipulator> manipulators = new ArrayList<ArbitraryManipulator>();
        Map<Property, List<ArbitraryNode>> nodesByType = metadata.getNodesByProperty();
        List<MatcherOperator<ArbitraryBuilder<?>>> registeredArbitraryBuilders = manipulateOptions.getRegisteredArbitraryBuilders();
        for (Map.Entry<Property, List<ArbitraryNode>> nodeByType : nodesByType.entrySet()) {
            Property property = nodeByType.getKey();
            List<ArbitraryNode> arbitraryNodes = nodeByType.getValue();
            DefaultArbitraryBuilder registeredArbitraryBuilder = registeredArbitraryBuilders.stream().filter(it -> it.match(property)).findFirst().map(MatcherOperator::getOperator).filter(it -> it instanceof DefaultArbitraryBuilder).orElse(null);
            if (registeredArbitraryBuilder == null) continue;
            ArbitraryBuilderContext context = registeredArbitraryBuilder.getContext();
            List arbitraryManipulators = context.getManipulators().stream().map(it -> it.withPrependNodeResolver(ArbitraryResolver.prependPropertyNodeResolver(property, arbitraryNodes))).collect(Collectors.toList());
            manipulators.addAll(arbitraryManipulators);
        }
        return manipulators;
    }

    private static NodeResolver prependPropertyNodeResolver(final Property property, final List<ArbitraryNode> arbitraryNodes) {
        return new NodeResolver(){

            @Override
            public List<ArbitraryNode> resolve(ArbitraryNode arbitraryNode) {
                for (ArbitraryNode node : arbitraryNodes) {
                    node.setManipulated(true);
                }
                return arbitraryNodes;
            }

            @Override
            public List<NextNodePredicate> toNextNodePredicate() {
                return Collections.singletonList(new PropertyPredicate(property));
            }
        };
    }
}

