/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.IdentityNodeResolver;
import com.navercorp.fixturemonkey.resolver.NextNodePredicate;
import com.navercorp.fixturemonkey.resolver.NodeResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class CompositeNodeResolver
implements NodeResolver {
    private final List<NodeResolver> nodeResolvers;

    public CompositeNodeResolver(NodeResolver ... nodeResolvers) {
        this(Arrays.asList(nodeResolvers));
    }

    public CompositeNodeResolver(List<NodeResolver> nodeResolvers) {
        this.nodeResolvers = this.distinct(nodeResolvers);
    }

    @Override
    public List<ArbitraryNode> resolve(ArbitraryNode arbitraryNode) {
        LinkedList<ArbitraryNode> nextNodes = new LinkedList<ArbitraryNode>();
        nextNodes.add(arbitraryNode);
        for (NodeResolver nodeResolver : this.nodeResolvers) {
            LinkedList<ArbitraryNode> resolvedNodes = new LinkedList<ArbitraryNode>();
            while (!nextNodes.isEmpty()) {
                ArbitraryNode currentNode = nextNodes.pop();
                resolvedNodes.addAll(nodeResolver.resolve(currentNode));
            }
            nextNodes.addAll(resolvedNodes);
        }
        return nextNodes;
    }

    public List<NodeResolver> flatten() {
        ArrayList<NodeResolver> flatten = new ArrayList<NodeResolver>();
        for (NodeResolver nodeResolver : this.nodeResolvers) {
            if (nodeResolver instanceof CompositeNodeResolver) {
                flatten.addAll(((CompositeNodeResolver)nodeResolver).nodeResolvers);
                continue;
            }
            flatten.add(nodeResolver);
        }
        return flatten;
    }

    private List<NodeResolver> distinct(List<NodeResolver> resolvers) {
        if (resolvers.isEmpty()) {
            return Collections.emptyList();
        }
        int length = resolvers.size();
        ArrayList<NodeResolver> result = new ArrayList<NodeResolver>();
        result.add(resolvers.get(0));
        for (int i = 1; i < length; ++i) {
            NodeResolver resolver = resolvers.get(i);
            if (resolver instanceof CompositeNodeResolver) {
                CompositeNodeResolver compositeNodeResolver = (CompositeNodeResolver)resolver;
                List<NodeResolver> componentNodeResolvers = compositeNodeResolver.flatten().stream().filter(it -> !(it instanceof IdentityNodeResolver)).collect(Collectors.toList());
                result.add(new CompositeNodeResolver(componentNodeResolvers));
                continue;
            }
            result.add(resolver);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeNodeResolver that = (CompositeNodeResolver)obj;
        return this.nodeResolvers.equals(that.nodeResolvers);
    }

    public int hashCode() {
        return Objects.hash(this.nodeResolvers);
    }

    @Override
    public List<NextNodePredicate> toNextNodePredicate() {
        return this.flatten().stream().flatMap(it -> it.toNextNodePredicate().stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

