/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.resolver.NextNodePredicate;
import com.navercorp.fixturemonkey.resolver.PropertyPredicate;
import com.navercorp.fixturemonkey.resolver.StartNodePredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class ContainerInfoManipulator {
    private final List<NextNodePredicate> nextNodePredicates;
    private ArbitraryContainerInfo containerInfo;

    public ContainerInfoManipulator(List<NextNodePredicate> nextNodePredicates, ArbitraryContainerInfo containerInfo) {
        this.nextNodePredicates = nextNodePredicates;
        this.containerInfo = containerInfo;
    }

    public ContainerInfoManipulator copy() {
        return new ContainerInfoManipulator(this.getNextNodePredicates(), new ArbitraryContainerInfo(this.containerInfo.getElementMinSize(), this.containerInfo.getElementMaxSize(), this.containerInfo.getManipulatingSequence()));
    }

    public List<NextNodePredicate> getNextNodePredicates() {
        return this.nextNodePredicates;
    }

    public ArbitraryContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    ContainerInfoManipulator withPrependNextNodePredicate(NextNodePredicate nextNodePredicate) {
        List nodePredicatesWithoutRoot = this.nextNodePredicates.stream().filter(it -> !(it instanceof StartNodePredicate)).collect(Collectors.toList());
        ArrayList<NextNodePredicate> newNextNodePredicates = new ArrayList<NextNodePredicate>();
        newNextNodePredicates.add(nextNodePredicate);
        newNextNodePredicates.addAll(nodePredicatesWithoutRoot);
        return new ContainerInfoManipulator(newNextNodePredicates, this.containerInfo);
    }

    public void fixed() {
        int fixedSize = this.containerInfo.getRandomSize();
        this.containerInfo = new ArbitraryContainerInfo(fixedSize, fixedSize, this.containerInfo.getManipulatingSequence());
    }

    public boolean isMatch(List<ObjectProperty> objectProperties) {
        int objectPropertiesSize = objectProperties.size();
        int nextNodePredicateSize = this.nextNodePredicates.size();
        boolean registered = this.nextNodePredicates.get(0) instanceof PropertyPredicate;
        if (!registered && nextNodePredicateSize != objectPropertiesSize) {
            return false;
        }
        for (int i = 0; i < nextNodePredicateSize; ++i) {
            ObjectProperty objectProperty;
            int reversedNextNodePredicateIndex = nextNodePredicateSize - 1 - i;
            int reversedCurrentObjectPropertyIndex = objectPropertiesSize - 1 - i;
            NextNodePredicate nextNodePredicate = this.nextNodePredicates.get(reversedNextNodePredicateIndex);
            if (nextNodePredicate.test(objectProperty = objectProperties.get(reversedCurrentObjectPropertyIndex))) continue;
            return false;
        }
        return true;
    }
}

