/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.expression.ExpressionGenerator;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.type.LazyAnnotatedType;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import com.navercorp.fixturemonkey.customizer.InnerSpec;
import com.navercorp.fixturemonkey.customizer.ManipulatorSet;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.resolver.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.resolver.ArbitraryManipulator;
import com.navercorp.fixturemonkey.resolver.ArbitraryResolver;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ArbitraryValue;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class DefaultArbitraryBuilder<T>
implements ArbitraryBuilder<T> {
    private final ManipulateOptions manipulateOptions;
    private final RootProperty rootProperty;
    private final ArbitraryResolver resolver;
    private final ArbitraryTraverser traverser;
    private final ArbitraryValidator validator;
    private final MonkeyManipulatorFactory monkeyManipulatorFactory;
    private final ArbitraryBuilderContext context;

    public DefaultArbitraryBuilder(ManipulateOptions manipulateOptions, RootProperty rootProperty, ArbitraryResolver resolver, ArbitraryTraverser traverser, ArbitraryValidator validator, MonkeyManipulatorFactory monkeyManipulatorFactory, ArbitraryBuilderContext context) {
        this.manipulateOptions = manipulateOptions;
        this.rootProperty = rootProperty;
        this.resolver = resolver;
        this.traverser = traverser;
        this.validator = validator;
        this.context = context;
        this.monkeyManipulatorFactory = monkeyManipulatorFactory;
    }

    @Override
    public ArbitraryBuilder<T> validOnly(boolean validOnly) {
        this.context.setValidOnly(validOnly);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> set(String expression, @Nullable Object value, int limit) {
        if (value instanceof InnerSpec) {
            this.setInner((InnerSpec)value);
        } else {
            ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, value, limit);
            this.context.addManipulator(arbitraryManipulator);
        }
        return this;
    }

    @Override
    public ArbitraryBuilder<T> set(String expression, @Nullable Object value) {
        return this.set(expression, value, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> set(@Nullable Object value) {
        return this.set("$", value);
    }

    @Override
    public ArbitraryBuilder<T> set(ExpressionGenerator expressionGenerator, @Nullable Object value, int limit) {
        return this.set(this.resolveExpression(expressionGenerator), value, limit);
    }

    @Override
    public ArbitraryBuilder<T> set(ExpressionGenerator expressionGenerator, @Nullable Object value) {
        return this.set(this.resolveExpression(expressionGenerator), value);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(String expression, Supplier<?> supplier, int limit) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, supplier, limit);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> setLazy(String expression, Supplier<?> supplier) {
        return this.setLazy(expression, supplier, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(ExpressionGenerator expressionGenerator, Supplier<?> supplier, int limit) {
        return this.setLazy(this.resolveExpression(expressionGenerator), supplier, limit);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(ExpressionGenerator expressionGenerator, Supplier<?> supplier) {
        return this.setLazy(this.resolveExpression(expressionGenerator), supplier, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> setInner(InnerSpec innerSpec) {
        ManipulatorSet manipulatorSet = innerSpec.getManipulatorSet(this.monkeyManipulatorFactory);
        List<ArbitraryManipulator> arbitraryManipulators = manipulatorSet.getArbitraryManipulators();
        List<ContainerInfoManipulator> containerInfoManipulators = manipulatorSet.getContainerInfoManipulators();
        this.context.addManipulators(arbitraryManipulators);
        this.context.addContainerInfoManipulators(containerInfoManipulators);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> minSize(String expression, int min) {
        return this.size(expression, min, min + 3);
    }

    @Override
    public ArbitraryBuilder<T> minSize(ExpressionGenerator expressionGenerator, int min) {
        return this.size(this.resolveExpression(expressionGenerator), min, min + 3);
    }

    @Override
    public ArbitraryBuilder<T> maxSize(String expression, int max) {
        return this.size(expression, Math.max(0, max - 3), max);
    }

    @Override
    public ArbitraryBuilder<T> maxSize(ExpressionGenerator expressionGenerator, int max) {
        return this.size(this.resolveExpression(expressionGenerator), Math.max(0, max - 3), max);
    }

    @Override
    public ArbitraryBuilder<T> size(String expression, int size) {
        return this.size(expression, size, size);
    }

    @Override
    public ArbitraryBuilder<T> size(ExpressionGenerator expressionGenerator, int size) {
        return this.size(this.resolveExpression(expressionGenerator), size, size);
    }

    @Override
    public ArbitraryBuilder<T> size(String expression, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("should be min > max, min : " + min + " max : " + max);
        }
        ContainerInfoManipulator containerInfoManipulator = this.monkeyManipulatorFactory.newContainerInfoManipulator(expression, min, max);
        this.context.addContainerInfoManipulator(containerInfoManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> size(ExpressionGenerator expressionGenerator, int min, int max) {
        return this.size(this.resolveExpression(expressionGenerator), min, max);
    }

    @Override
    public ArbitraryBuilder<T> fixed() {
        this.context.getContainerInfoManipulators().forEach(ContainerInfoManipulator::fixed);
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator("$", this.sample());
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> apply(BiConsumer<T, ArbitraryBuilder<T>> biConsumer) {
        this.context.getContainerInfoManipulators().forEach(ContainerInfoManipulator::fixed);
        ArbitraryBuilder appliedBuilder = this.copy();
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> {
            ArbitraryBuilder lazyBuilder = appliedBuilder.copy();
            Object sampled = lazyBuilder.fixed().sample();
            biConsumer.accept(sampled, lazyBuilder);
            return lazyBuilder.sample();
        });
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator("$", lazyArbitrary);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> acceptIf(Predicate<T> predicate, Consumer<ArbitraryBuilder<T>> consumer) {
        return this.apply((it, builder) -> {
            if (predicate.test(it)) {
                consumer.accept((ArbitraryBuilder)builder);
            }
        });
    }

    @Override
    public ArbitraryBuilder<T> setNull(String expression) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, null);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> setNull(ExpressionGenerator expressionGenerator) {
        return this.setNull(this.resolveExpression(expressionGenerator));
    }

    @Override
    public ArbitraryBuilder<T> setNotNull(String expression) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newNotNullArbitraryManipulator(expression);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> setNotNull(ExpressionGenerator expressionGenerator) {
        return this.setNotNull(this.resolveExpression(expressionGenerator));
    }

    @Override
    public ArbitraryBuilder<T> setPostCondition(Predicate<T> filter) {
        return this.setPostCondition("$", Types.getActualType((Type)this.rootProperty.getType()), filter);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> type, Predicate<U> filter) {
        return this.setPostCondition(expression, type, filter, Integer.MAX_VALUE);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> type, Predicate<U> filter, int limit) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, type, filter, limit);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(ExpressionGenerator expressionGenerator, Class<U> clazz, Predicate<U> filter, int limit) {
        return this.setPostCondition(this.resolveExpression(expressionGenerator), clazz, filter, limit);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(ExpressionGenerator expressionGenerator, Class<U> clazz, Predicate<U> filter) {
        return this.setPostCondition(this.resolveExpression(expressionGenerator), clazz, filter);
    }

    @Override
    public <U> ArbitraryBuilder<U> map(Function<T, U> mapper) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> mapper.apply(this.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, BiFunction<T, U, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, V, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, Combinators.F3<T, U, V, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample(), another.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, V, W, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, ArbitraryBuilder<W> theOther, Combinators.F4<T, U, V, W, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample(), another.sample(), theOther.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <R> ArbitraryBuilder<R> zipWith(List<ArbitraryBuilder<?>> others, Function<List<?>, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> {
            ArrayList combinedList = new ArrayList();
            combinedList.add(this.sample());
            for (ArbitraryBuilder other : others) {
                combinedList.add(other.sample());
            }
            return combinator.apply(combinedList);
        });
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public ArbitraryBuilder<T> customize(MatcherOperator<FixtureCustomizer<T>> fixtureCustomizer) {
        this.context.addCustomizer(fixtureCustomizer);
        return this;
    }

    @Override
    public Arbitrary<T> build() {
        ArrayList<ArbitraryManipulator> buildManipulators = new ArrayList<ArbitraryManipulator>(this.context.getManipulators());
        return new ArbitraryValue(() -> this.resolver.resolve(this.rootProperty, buildManipulators, this.context.getCustomizers(), this.context.getContainerInfoManipulators()), this.validator, this.context.isValidOnly());
    }

    @Override
    public T sample() {
        return (T)this.build().sample();
    }

    @Override
    public Stream<T> sampleStream() {
        return this.build().sampleStream();
    }

    @Override
    public List<T> sampleList(int size) {
        return this.sampleStream().limit(size).collect(Collectors.toList());
    }

    @Override
    public ArbitraryBuilder<T> copy() {
        return new DefaultArbitraryBuilder<T>(this.manipulateOptions, this.rootProperty, this.resolver, this.traverser, this.validator, this.monkeyManipulatorFactory, this.context.copy());
    }

    ArbitraryBuilderContext getContext() {
        return this.context;
    }

    private String resolveExpression(ExpressionGenerator expressionGenerator) {
        return expressionGenerator.generate(property -> {
            PropertyNameResolver propertyNameResolver = this.manipulateOptions.getPropertyNameResolver(property);
            return propertyNameResolver.resolve(property);
        });
    }

    private <R> DefaultArbitraryBuilder<R> generateArbitraryBuilderLazily(LazyArbitrary<R> lazyArbitrary) {
        ArbitraryBuilderContext context = new ArbitraryBuilderContext();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator("$", lazyArbitrary);
        context.addManipulator(arbitraryManipulator);
        return new DefaultArbitraryBuilder<T>(this.manipulateOptions, new RootProperty((AnnotatedType)new LazyAnnotatedType(() -> lazyArbitrary.getValue())), this.resolver, this.traverser, this.validator, this.monkeyManipulatorFactory, context);
    }
}

