/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.collection.IteratorCache;
import com.navercorp.fixturemonkey.api.collection.StreamCache;
import com.navercorp.fixturemonkey.resolver.DecomposableContainerValue;
import com.navercorp.fixturemonkey.resolver.DecomposedContainerValueFactory;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class DefaultDecomposedContainerValueFactory
implements DecomposedContainerValueFactory {
    private final DecomposedContainerValueFactory additionalDecomposedContainerValueFactory;

    public DefaultDecomposedContainerValueFactory(DecomposedContainerValueFactory additionalDecomposedContainerValueFactory) {
        this.additionalDecomposedContainerValueFactory = additionalDecomposedContainerValueFactory;
    }

    @Override
    public DecomposableContainerValue from(Object value) {
        Class<?> actualType = value.getClass();
        if (Iterable.class.isAssignableFrom(actualType)) {
            Iterator iterator = ((Iterable)value).iterator();
            List list = IteratorCache.getList(iterator);
            return new DecomposableContainerValue(list, list.size());
        }
        if (Iterator.class.isAssignableFrom(actualType)) {
            Iterator iterator = (Iterator)value;
            List list = IteratorCache.getList((Iterator)iterator);
            return new DecomposableContainerValue(list, list.size());
        }
        if (Stream.class.isAssignableFrom(actualType)) {
            List container = StreamCache.getList((Stream)((Stream)value));
            return new DecomposableContainerValue(container, container.size());
        }
        if (actualType.isArray()) {
            return new DecomposableContainerValue(value, Array.getLength(value));
        }
        if (Map.class.isAssignableFrom(actualType)) {
            Map map = (Map)value;
            return new DecomposableContainerValue(value, map.size());
        }
        if (Map.Entry.class.isAssignableFrom(actualType)) {
            return new DecomposableContainerValue(value, 1);
        }
        if (this.isOptional(actualType)) {
            return new DecomposableContainerValue(value, 1);
        }
        return this.additionalDecomposedContainerValueFactory.from(value);
    }

    private boolean isOptional(Class<?> type) {
        return Optional.class.isAssignableFrom(type) || OptionalInt.class.isAssignableFrom(type) || OptionalLong.class.isAssignableFrom(type) || OptionalDouble.class.isAssignableFrom(type);
    }
}

