/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.ArbitraryTreeMetadata;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
final class MetadataCollector {
    private final ArbitraryNode rootNode;
    private final Map<Property, List<ArbitraryNode>> nodesByProperty;

    public MetadataCollector(ArbitraryNode rootNode) {
        this.rootNode = rootNode;
        this.nodesByProperty = new LinkedHashMap<Property, List<ArbitraryNode>>();
    }

    public ArbitraryTreeMetadata collect() {
        for (ArbitraryNode child : this.rootNode.getChildren()) {
            this.collect(child);
        }
        return new ArbitraryTreeMetadata(Collections.unmodifiableMap(this.nodesByProperty));
    }

    private void collect(ArbitraryNode node) {
        Property property = node.getArbitraryProperty().getObjectProperty().getProperty();
        List<ArbitraryNode> children = node.getChildren();
        for (ArbitraryNode child : children) {
            this.collect(child);
        }
        List<ArbitraryNode> list = Collections.singletonList(node);
        this.nodesByProperty.merge(property, list, (prev, now) -> Stream.concat(prev.stream(), now.stream()).collect(Collectors.toList()));
    }
}

