/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.NodeManipulator;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class NodeFilterManipulator
implements NodeManipulator {
    private final Class<?> type;
    private final Predicate filter;

    public NodeFilterManipulator(Class<?> type, Predicate filter) {
        this.type = type;
        this.filter = filter;
    }

    @Override
    public void manipulate(ArbitraryNode arbitraryNode) {
        Class actualType = Types.getActualType((Type)arbitraryNode.getProperty().getType());
        if (!actualType.isAssignableFrom(this.type)) {
            throw new IllegalArgumentException("Wrong type filter is applied. Expected: " + this.type + ", Actual: " + actualType);
        }
        arbitraryNode.addArbitraryFilter(this.filter);
    }
}

