/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.resolver.ArbitraryNode;
import com.navercorp.fixturemonkey.resolver.ArbitraryTraverser;
import com.navercorp.fixturemonkey.resolver.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.resolver.DecomposableContainerValue;
import com.navercorp.fixturemonkey.resolver.IdentityNodeResolver;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.NodeManipulator;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.EXPERIMENTAL)
public final class NodeSetDecomposedValueManipulator<T>
implements NodeManipulator {
    private final int sequence;
    private final ArbitraryTraverser traverser;
    private final ManipulateOptions manipulateOptions;
    @Nullable
    private final T value;

    public NodeSetDecomposedValueManipulator(int sequence, ArbitraryTraverser traverser, ManipulateOptions manipulateOptions, @Nullable T value) {
        this.sequence = sequence;
        this.traverser = traverser;
        this.manipulateOptions = manipulateOptions;
        this.value = value;
    }

    @Override
    public void manipulate(ArbitraryNode arbitraryNode) {
        Class actualType = Types.getActualType((Type)arbitraryNode.getProperty().getType());
        if (this.value != null && !Types.isAssignable(this.value.getClass(), (Class)actualType)) {
            String parentNodeLogMessage = arbitraryNode.getResolvedParentProperty() != null ? String.format("parent node type : %s", arbitraryNode.getResolvedParentProperty().getType().getTypeName()) : "";
            throw new IllegalArgumentException(String.format("The value is not of the same type as the property.\n%s node name: %s, node type: %s, value type: %s", parentNodeLogMessage, arbitraryNode.getArbitraryProperty().getObjectProperty().getResolvedPropertyName(), arbitraryNode.getProperty().getType().getTypeName(), this.value.getClass().getTypeName()));
        }
        this.setValue(arbitraryNode, this.value);
    }

    private void setValue(ArbitraryNode arbitraryNode, @Nullable Object value) {
        arbitraryNode.setManipulated(true);
        arbitraryNode.setArbitraryProperty(arbitraryNode.getArbitraryProperty().withNullInject(0.0));
        if (value == null) {
            arbitraryNode.setArbitraryProperty(arbitraryNode.getArbitraryProperty().withNullInject(1.0));
            return;
        }
        ContainerProperty containerProperty = arbitraryNode.getArbitraryProperty().getContainerProperty();
        if (containerProperty != null) {
            boolean forced;
            DecomposableContainerValue decomposableContainerValue = this.manipulateOptions.getDecomposedContainerValueFactory().from(value);
            Object containerValue = decomposableContainerValue.getContainer();
            int decomposedContainerSize = decomposableContainerValue.getSize();
            boolean bl = forced = containerProperty.getContainerInfo().getManipulatingSequence() == null || this.sequence > containerProperty.getContainerInfo().getManipulatingSequence();
            if (forced) {
                ContainerInfoManipulator containerInfoManipulator = new ContainerInfoManipulator(IdentityNodeResolver.INSTANCE.toNextNodePredicate(), new ArbitraryContainerInfo(decomposedContainerSize, decomposedContainerSize));
                ArbitraryNode newNode = this.traverser.traverse(arbitraryNode.getProperty(), Collections.singletonList(containerInfoManipulator), Collections.emptyList());
                arbitraryNode.setArbitraryProperty(arbitraryNode.getArbitraryProperty().withContainerProperty(newNode.getArbitraryProperty().getContainerProperty()));
                arbitraryNode.setChildren(newNode.getChildren());
            }
            List<ArbitraryNode> children = arbitraryNode.getChildren();
            if (arbitraryNode.getArbitraryProperty().getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
                decomposedContainerSize *= 2;
            }
            int decomposedNodeSize = Math.min(decomposedContainerSize, children.size());
            for (int i = 0; i < decomposedNodeSize; ++i) {
                ArbitraryNode child = children.get(i);
                Property childProperty = child.getProperty();
                this.setValue(child, childProperty.getValue(containerValue));
            }
            return;
        }
        List<ArbitraryNode> children = arbitraryNode.getChildren();
        if (children.isEmpty() || Types.getActualType((Type)arbitraryNode.getProperty().getType()).isInterface()) {
            arbitraryNode.setArbitrary(Arbitraries.just((Object)value));
            return;
        }
        Map.Entry childPropertiesByResolvedProperty = arbitraryNode.getArbitraryProperty().getObjectProperty().getChildPropertiesByResolvedProperty(property -> Types.isAssignable((Class)Types.getActualType((Type)property.getType()), value.getClass()));
        arbitraryNode.setArbitraryProperty(arbitraryNode.getArbitraryProperty().withChildPropertyListsByCandidateProperty(Collections.singletonMap(childPropertiesByResolvedProperty.getKey(), childPropertiesByResolvedProperty.getValue())));
        Property resolvedParentProperty = (Property)childPropertiesByResolvedProperty.getKey();
        List childProperties = (List)childPropertiesByResolvedProperty.getValue();
        for (ArbitraryNode child : children) {
            if (!childProperties.contains(child.getProperty()) || !resolvedParentProperty.equals(child.getResolvedParentProperty())) continue;
            Property childProperty = child.getProperty();
            this.setValue(child, childProperty.getValue(value));
        }
    }
}

