/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.resolver.DecomposableContainerValue;
import com.navercorp.fixturemonkey.resolver.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import com.navercorp.fixturemonkey.tree.IdentityNodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class NodeSetDecomposedValueManipulator<T>
implements NodeManipulator {
    private final int sequence;
    private final ArbitraryTraverser traverser;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;
    @Nullable
    private final T value;

    public NodeSetDecomposedValueManipulator(int sequence, ArbitraryTraverser traverser, DecomposedContainerValueFactory decomposedContainerValueFactory, @Nullable T value) {
        this.sequence = sequence;
        this.traverser = traverser;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        this.value = value;
    }

    @Override
    public void manipulate(ObjectNode objectNode) {
        Class actualType = Types.getActualType((Type)objectNode.getProperty().getType());
        if (this.value != null && !Types.isAssignable(this.value.getClass(), (Class)actualType)) {
            String parentNodeLogMessage = objectNode.getResolvedParentProperty() != null ? String.format("parent node type : %s", objectNode.getResolvedParentProperty().getType().getTypeName()) : "";
            throw new IllegalArgumentException(String.format("The value is not of the same type as the property.\n%s node name: %s, node type: %s, value type: %s", parentNodeLogMessage, objectNode.getArbitraryProperty().getObjectProperty().getResolvedPropertyName(), objectNode.getProperty().getType().getTypeName(), this.value.getClass().getTypeName()));
        }
        this.setValue(objectNode, this.value);
    }

    private void setValue(ObjectNode objectNode, @Nullable Object value) {
        objectNode.setManipulated(true);
        objectNode.setArbitraryProperty(objectNode.getArbitraryProperty().withNullInject(0.0));
        if (value == null) {
            objectNode.setArbitraryProperty(objectNode.getArbitraryProperty().withNullInject(1.0));
            return;
        }
        ContainerProperty containerProperty = objectNode.getArbitraryProperty().getContainerProperty();
        if (containerProperty != null) {
            boolean forced;
            DecomposableContainerValue decomposableContainerValue = this.decomposedContainerValueFactory.from(value);
            Object containerValue = decomposableContainerValue.getContainer();
            int decomposedContainerSize = decomposableContainerValue.getSize();
            boolean bl = forced = containerProperty.getContainerInfo().getManipulatingSequence() == null || this.sequence > containerProperty.getContainerInfo().getManipulatingSequence();
            if (forced) {
                ContainerInfoManipulator containerInfoManipulator = new ContainerInfoManipulator(IdentityNodeResolver.INSTANCE.toNextNodePredicate(), new ArbitraryContainerInfo(decomposedContainerSize, decomposedContainerSize));
                ObjectNode newNode = this.traverser.traverse(objectNode.getProperty(), Collections.singletonList(containerInfoManipulator), Collections.emptyList());
                objectNode.setArbitraryProperty(objectNode.getArbitraryProperty().withContainerProperty(newNode.getArbitraryProperty().getContainerProperty()));
                objectNode.setChildren(newNode.getChildren());
            }
            List<ObjectNode> children = objectNode.getChildren();
            if (objectNode.getArbitraryProperty().getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
                decomposedContainerSize *= 2;
            }
            int decomposedNodeSize = Math.min(decomposedContainerSize, children.size());
            for (int i = 0; i < decomposedNodeSize; ++i) {
                ObjectNode child = children.get(i);
                Property childProperty = child.getProperty();
                this.setValue(child, childProperty.getValue(containerValue));
            }
            return;
        }
        List<ObjectNode> children = objectNode.getChildren();
        if (children.isEmpty() || Types.getActualType((Type)objectNode.getProperty().getType()).isInterface()) {
            objectNode.setArbitrary(Arbitraries.just((Object)value));
            return;
        }
        Map.Entry childPropertiesByResolvedProperty = objectNode.getArbitraryProperty().getObjectProperty().getChildPropertiesByResolvedProperty(property -> Types.isAssignable((Class)Types.getActualType((Type)property.getType()), value.getClass()));
        Property resolvedParentProperty = (Property)childPropertiesByResolvedProperty.getKey();
        objectNode.setResolvedProperty(resolvedParentProperty);
        List childProperties = (List)childPropertiesByResolvedProperty.getValue();
        for (ObjectNode child : children) {
            if (!childProperties.contains(child.getProperty()) || !resolvedParentProperty.equals(child.getResolvedParentProperty())) continue;
            Property childProperty = child.getProperty();
            this.setValue(child, childProperty.getValue(value));
        }
    }
}

