/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryBuilderContext {
    private final List<ArbitraryManipulator> manipulators;
    private final List<MatcherOperator<? extends FixtureCustomizer>> customizers;
    private final List<ContainerInfoManipulator> containerInfoManipulators;
    private boolean validOnly;

    public ArbitraryBuilderContext(List<ArbitraryManipulator> manipulators, List<MatcherOperator<? extends FixtureCustomizer>> customizers, List<ContainerInfoManipulator> containerInfoManipulators, boolean validOnly) {
        this.manipulators = manipulators;
        this.customizers = customizers;
        this.containerInfoManipulators = containerInfoManipulators;
        this.validOnly = validOnly;
    }

    public ArbitraryBuilderContext() {
        this(new ArrayList<ArbitraryManipulator>(), new ArrayList<MatcherOperator<? extends FixtureCustomizer>>(), new ArrayList<ContainerInfoManipulator>(), true);
    }

    public ArbitraryBuilderContext copy() {
        List<ContainerInfoManipulator> copiedContainerInfoManipulators = this.containerInfoManipulators.stream().map(ContainerInfoManipulator::copy).collect(Collectors.toList());
        return new ArbitraryBuilderContext(new ArrayList<ArbitraryManipulator>(this.manipulators), new ArrayList<MatcherOperator<? extends FixtureCustomizer>>(this.customizers), copiedContainerInfoManipulators, this.validOnly);
    }

    public void addManipulator(ArbitraryManipulator arbitraryManipulator) {
        this.manipulators.add(arbitraryManipulator);
    }

    public void addManipulators(Collection<ArbitraryManipulator> arbitraryManipulators) {
        this.manipulators.addAll(arbitraryManipulators);
    }

    public List<ArbitraryManipulator> getManipulators() {
        return Collections.unmodifiableList(this.manipulators);
    }

    public void addCustomizer(MatcherOperator<? extends FixtureCustomizer> fixtureCustomizer) {
        this.customizers.add(fixtureCustomizer);
    }

    public List<MatcherOperator<? extends FixtureCustomizer>> getCustomizers() {
        return Collections.unmodifiableList(this.customizers);
    }

    public void addContainerInfoManipulator(ContainerInfoManipulator containerInfo) {
        this.containerInfoManipulators.add(containerInfo);
    }

    public void addContainerInfoManipulators(List<ContainerInfoManipulator> containerInfoManipulators) {
        this.containerInfoManipulators.addAll(containerInfoManipulators);
    }

    public List<ContainerInfoManipulator> getContainerInfoManipulators() {
        return Collections.unmodifiableList(this.containerInfoManipulators);
    }

    public void setValidOnly(boolean validOnly) {
        this.validOnly = validOnly;
    }

    public boolean isValidOnly() {
        return this.validOnly;
    }
}

