/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.resolver.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.resolver.ManipulateOptions;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import com.navercorp.fixturemonkey.tree.ObjectTree;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryResolver {
    private final ArbitraryTraverser traverser;
    private final ManipulatorOptimizer manipulatorOptimizer;
    private final MonkeyManipulatorFactory monkeyManipulatorFactory;
    private final GenerateOptions generateOptions;
    private final ManipulateOptions manipulateOptions;
    private final MonkeyContext monkeyContext;

    public ArbitraryResolver(ArbitraryTraverser traverser, ManipulatorOptimizer manipulatorOptimizer, MonkeyManipulatorFactory monkeyManipulatorFactory, GenerateOptions generateOptions, ManipulateOptions manipulateOptions, MonkeyContext monkeyContext) {
        this.traverser = traverser;
        this.manipulatorOptimizer = manipulatorOptimizer;
        this.monkeyManipulatorFactory = monkeyManipulatorFactory;
        this.generateOptions = generateOptions;
        this.manipulateOptions = manipulateOptions;
        this.monkeyContext = monkeyContext;
    }

    public Arbitrary<?> resolve(RootProperty rootProperty, List<ArbitraryManipulator> manipulators, List<MatcherOperator<? extends FixtureCustomizer>> customizers, List<ContainerInfoManipulator> containerInfoManipulators) {
        List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators = this.manipulateOptions.getRegisteredArbitraryBuilders().stream().map(it -> new MatcherOperator(it.getMatcher(), ((DefaultArbitraryBuilder)it.getOperator()).getContext().getContainerInfoManipulators())).collect(Collectors.toList());
        ObjectTree objectTree = new ObjectTree(rootProperty, this.traverser.traverse((Property)rootProperty, containerInfoManipulators, registeredContainerInfoManipulators), this.generateOptions, this.monkeyContext, customizers);
        List<ArbitraryManipulator> registeredManipulators = this.monkeyManipulatorFactory.newRegisteredArbitraryManipulators(this.manipulateOptions.getRegisteredArbitraryBuilders(), objectTree.getMetadata().getNodesByProperty());
        List<ArbitraryManipulator> joinedManipulators = Stream.concat(registeredManipulators.stream(), manipulators.stream()).collect(Collectors.toList());
        List<ArbitraryManipulator> optimizedManipulator = this.manipulatorOptimizer.optimize(joinedManipulators).getManipulators();
        for (ArbitraryManipulator manipulator : optimizedManipulator) {
            manipulator.manipulate(objectTree);
        }
        return objectTree.generate();
    }
}

