/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
final class ArbitraryValue<T>
implements Arbitrary<T> {
    private final MonkeyRandomGenerator<T> monkeyRandomGenerator;

    public ArbitraryValue(Supplier<Arbitrary<T>> generateArbitrary, ArbitraryValidator validator, boolean validOnly) {
        this.monkeyRandomGenerator = new MonkeyRandomGenerator(generateArbitrary, validator, validOnly);
    }

    public RandomGenerator<T> generator(int genSize) {
        return this.monkeyRandomGenerator;
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        return EdgeCases.none();
    }

    public boolean isGeneratorMemoizable() {
        return false;
    }

    private static final class MonkeyRandomGenerator<T>
    implements RandomGenerator<T> {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Supplier<Arbitrary<T>> generateArbitrary;
        private final boolean validOnly;
        private final ArbitraryValidator validator;
        private final Map<String, ConstraintViolation> violations = new ConcurrentHashMap<String, ConstraintViolation>();
        private Exception lastException;

        private MonkeyRandomGenerator(Supplier<Arbitrary<T>> generateArbitrary, ArbitraryValidator validator, boolean validOnly) {
            this.generateArbitrary = generateArbitrary;
            this.validator = validator;
            this.validOnly = validOnly;
        }

        public Shrinkable<T> next(Random random) {
            try {
                return this.getArbitrary().filter(this.validateFilter(this.validOnly)).generator(1000).next(random);
            }
            catch (TooManyFilterMissesException ex) {
                StringBuilder builder = new StringBuilder();
                this.violations.values().forEach(violation -> builder.append("- violation: ").append(violation.getMessage()).append(", type: ").append(violation.getRootBeanClass()).append(", property: ").append(violation.getPropertyPath()).append(", invalidValue: ").append(violation.getInvalidValue()).append("\n"));
                this.log.error("Fail to create valid arbitrary.\n\nFixture factory Constraint Violation messages. \n\n" + builder, (Throwable)this.lastException);
                throw ex;
            }
        }

        private Predicate validateFilter(boolean validOnly) {
            return fixture -> {
                if (!validOnly) {
                    return true;
                }
                if (fixture == null) {
                    return true;
                }
                try {
                    this.validator.validate(fixture);
                    return true;
                }
                catch (ConstraintViolationException ex) {
                    ex.getConstraintViolations().forEach(violation -> this.violations.put(violation.getRootBeanClass().getName() + violation.getPropertyPath(), (ConstraintViolation)violation));
                    this.lastException = ex;
                    return false;
                }
            };
        }

        private synchronized Arbitrary<T> getArbitrary() {
            return this.generateArbitrary.get();
        }
    }
}

