/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.resolver.ManipulateOptionsBuilder;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ManipulateOptions {
    private final MonkeyExpressionFactory defaultMonkeyExpressionFactory;
    private final List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;
    private final List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers;
    private final PropertyNameResolver defaultPropertyNameResolver;

    public ManipulateOptions(MonkeyExpressionFactory defaultMonkeyExpressionFactory, List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders, DecomposedContainerValueFactory decomposedContainerValueFactory, List<MatcherOperator<PropertyNameResolver>> propertyNameResolvers, PropertyNameResolver defaultPropertyNameResolver) {
        this.defaultMonkeyExpressionFactory = defaultMonkeyExpressionFactory;
        this.registeredArbitraryBuilders = registeredArbitraryBuilders;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        this.propertyNameResolvers = propertyNameResolvers;
        this.defaultPropertyNameResolver = defaultPropertyNameResolver;
    }

    public MonkeyExpressionFactory getDefaultMonkeyExpressionFactory() {
        return this.defaultMonkeyExpressionFactory;
    }

    public List<MatcherOperator<? extends ArbitraryBuilder<?>>> getRegisteredArbitraryBuilders() {
        return this.registeredArbitraryBuilders;
    }

    public DecomposedContainerValueFactory getDecomposedContainerValueFactory() {
        return this.decomposedContainerValueFactory;
    }

    public PropertyNameResolver getPropertyNameResolver(Property property) {
        return this.propertyNameResolvers.stream().filter(it -> it.match(property)).map(MatcherOperator::getOperator).findFirst().orElse(this.defaultPropertyNameResolver);
    }

    public static ManipulateOptionsBuilder builder() {
        return new ManipulateOptionsBuilder();
    }
}

