/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.SingleValueObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.random.Randoms;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.TraverseContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryTraverser {
    private final GenerateOptions generateOptions;

    public ArbitraryTraverser(GenerateOptions generateOptions) {
        this.generateOptions = generateOptions;
    }

    public ObjectNode traverse(Property property, List<ContainerInfoManipulator> containerInfoManipulators, List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators) {
        ContainerPropertyGenerator containerPropertyGenerator = this.generateOptions.getContainerPropertyGenerator(property);
        boolean container = containerPropertyGenerator != null;
        Object objectPropertyGenerator = container ? SingleValueObjectPropertyGenerator.INSTANCE : this.generateOptions.getObjectPropertyGenerator(property);
        ObjectProperty objectProperty = objectPropertyGenerator.generate(new ObjectPropertyGeneratorContext(property, null, null, container, this.generateOptions));
        ContainerProperty containerProperty = null;
        if (container) {
            ArbitraryContainerInfo containerInfo = containerInfoManipulators.stream().filter(it -> it.isMatch(Collections.singletonList(objectProperty))).findFirst().map(ContainerInfoManipulator::getContainerInfo).orElse(null);
            containerProperty = containerPropertyGenerator.generate(new ContainerPropertyGeneratorContext(property, null, containerInfo, this.generateOptions));
        }
        ArbitraryProperty arbitraryProperty = new ArbitraryProperty(objectProperty, containerProperty);
        ArrayList<ArbitraryProperty> parentArbitraryProperties = new ArrayList<ArbitraryProperty>();
        parentArbitraryProperties.add(arbitraryProperty);
        return this.traverse(arbitraryProperty, null, new TraverseContext(arbitraryProperty, parentArbitraryProperties, containerInfoManipulators, registeredContainerInfoManipulators));
    }

    private ObjectNode traverse(ArbitraryProperty arbitraryProperty, @Nullable Property resolvedParentProperty, TraverseContext context) {
        Property resolvedProperty;
        boolean container;
        ArrayList<ObjectNode> children = new ArrayList<ObjectNode>();
        ObjectProperty objectProperty = arbitraryProperty.getObjectProperty();
        ContainerProperty containerProperty = arbitraryProperty.getContainerProperty();
        boolean bl = container = containerProperty != null;
        if (container) {
            resolvedProperty = objectProperty.getProperty();
            List elementProperties = containerProperty.getElementProperties();
            children.addAll(this.generateChildrenNodes(elementProperties, arbitraryProperty, objectProperty.getProperty(), context));
        } else {
            Map childPropertyListsByCandidateProperty = objectProperty.getChildPropertyListsByCandidateProperty();
            for (Map.Entry childPropertiesByCandidateProperty : childPropertyListsByCandidateProperty.entrySet()) {
                List childProperties = (List)childPropertiesByCandidateProperty.getValue();
                Property candidateProperty = (Property)childPropertiesByCandidateProperty.getKey();
                children.addAll(this.generateChildrenNodes(childProperties, arbitraryProperty, candidateProperty, context));
            }
            resolvedProperty = (Property)new ArrayList(childPropertyListsByCandidateProperty.keySet()).get(Randoms.nextInt((int)childPropertyListsByCandidateProperty.size()));
        }
        return new ObjectNode(resolvedParentProperty, resolvedProperty, arbitraryProperty, children);
    }

    private List<ObjectNode> generateChildrenNodes(List<Property> childProperties, ArbitraryProperty parentArbitraryProperty, Property resolvedParentProperty, TraverseContext context) {
        ArrayList<ObjectNode> children = new ArrayList<ObjectNode>();
        List<ContainerInfoManipulator> containerInfoManipulators = context.getContainerInfoManipulators();
        boolean container = parentArbitraryProperty.getContainerProperty() != null;
        for (int sequence = 0; sequence < childProperties.size(); ++sequence) {
            Property childProperty = childProperties.get(sequence);
            ContainerPropertyGenerator containerPropertyGenerator = this.generateOptions.getContainerPropertyGenerator(childProperty);
            boolean childContainer = containerPropertyGenerator != null;
            Object objectPropertyGenerator = childContainer ? SingleValueObjectPropertyGenerator.INSTANCE : this.generateOptions.getObjectPropertyGenerator(childProperty);
            int index = sequence;
            if (parentArbitraryProperty.getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
                index /= 2;
            }
            ObjectProperty childObjectProperty = objectPropertyGenerator.generate(new ObjectPropertyGeneratorContext(childProperty, container ? Integer.valueOf(index) : null, parentArbitraryProperty, childContainer, this.generateOptions));
            ContainerProperty childContainerProperty = null;
            if (childContainer) {
                List<ObjectProperty> objectProperties = context.getArbitraryProperties().stream().map(ArbitraryProperty::getObjectProperty).collect(Collectors.toList());
                objectProperties.add(childObjectProperty);
                ArbitraryContainerInfo containerInfo = null;
                for (ContainerInfoManipulator containerInfoManipulator : containerInfoManipulators) {
                    if (!containerInfoManipulator.isMatch(objectProperties)) continue;
                    containerInfo = containerInfoManipulator.getContainerInfo();
                }
                childContainerProperty = containerPropertyGenerator.generate(new ContainerPropertyGeneratorContext(childProperty, container ? Integer.valueOf(index) : null, containerInfo, this.generateOptions));
            }
            ArbitraryProperty childArbitraryProperty = new ArbitraryProperty(childObjectProperty, childContainerProperty);
            ObjectNode childNode = context.isTraversed(childProperty) ? new ObjectNode(resolvedParentProperty, childProperty, childArbitraryProperty, Collections.emptyList()) : this.traverse(childArbitraryProperty, resolvedParentProperty, context.appendArbitraryProperty(childArbitraryProperty));
            children.add(childNode);
        }
        return children;
    }
}

