/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectNode {
    @Nullable
    private final Property resolvedParentProperty;
    private Property resolvedProperty;
    private ArbitraryProperty arbitraryProperty;
    private List<ObjectNode> children;
    @Nullable
    private Arbitrary<?> arbitrary;
    private boolean manipulated = false;
    private final List<Predicate> arbitraryFilters = new ArrayList<Predicate>();

    ObjectNode(@Nullable Property resolvedParentProperty, Property resolvedProperty, ArbitraryProperty arbitraryProperty, List<ObjectNode> children) {
        this.resolvedParentProperty = resolvedParentProperty;
        this.resolvedProperty = resolvedProperty;
        this.arbitraryProperty = arbitraryProperty;
        this.children = children;
    }

    public void setArbitraryProperty(ArbitraryProperty arbitraryProperty) {
        this.arbitraryProperty = arbitraryProperty;
    }

    public void setChildren(List<ObjectNode> children) {
        this.children = children;
    }

    public void setResolvedProperty(Property resolvedProperty) {
        this.resolvedProperty = resolvedProperty;
    }

    @Nullable
    public Property getResolvedParentProperty() {
        return this.resolvedParentProperty;
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.arbitraryProperty;
    }

    public Property getProperty() {
        return this.getArbitraryProperty().getObjectProperty().getProperty();
    }

    public List<ObjectNode> getChildren() {
        return this.children;
    }

    @Nullable
    public Arbitrary<?> getArbitrary() {
        return this.arbitrary;
    }

    public void setArbitrary(@Nullable Arbitrary<?> arbitrary) {
        this.arbitrary = arbitrary;
    }

    public Property getResolvedProperty() {
        return this.resolvedProperty;
    }

    public void addArbitraryFilter(Predicate filter) {
        this.arbitraryFilters.add(filter);
    }

    public List<Predicate> getArbitraryFilters() {
        return this.arbitraryFilters;
    }

    public boolean isNotManipulated() {
        boolean sized = this.arbitraryProperty.getContainerProperty() != null && this.arbitraryProperty.getContainerProperty().getContainerInfo().isManipulated();
        return !this.manipulated && !sized;
    }

    public void setManipulated(boolean manipulated) {
        this.manipulated = manipulated;
    }
}

