/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.customizer.FixtureCustomizer;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.FixedCombinableArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.GenerateOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.MetadataCollector;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectTreeMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectTree {
    private final RootProperty rootProperty;
    private final ObjectNode rootNode;
    private final GenerateOptions generateOptions;
    private final ObjectTreeMetadata metadata;
    private final MonkeyContext monkeyContext;
    private final List<MatcherOperator<? extends FixtureCustomizer>> customizers;

    public ObjectTree(RootProperty rootProperty, ObjectNode rootNode, GenerateOptions generateOptions, MonkeyContext monkeyContext, List<MatcherOperator<? extends FixtureCustomizer>> customizers) {
        this.rootProperty = rootProperty;
        this.rootNode = rootNode;
        this.generateOptions = generateOptions;
        this.monkeyContext = monkeyContext;
        this.customizers = customizers;
        MetadataCollector metadataCollector = new MetadataCollector(rootNode);
        this.metadata = metadataCollector.collect();
    }

    public ObjectTreeMetadata getMetadata() {
        return this.metadata;
    }

    public void manipulate(NodeResolver nodeResolver, NodeManipulator nodeManipulator) {
        List<ObjectNode> nodes = nodeResolver.resolve(this.rootNode);
        for (ObjectNode node : nodes) {
            nodeManipulator.manipulate(node);
        }
    }

    public Arbitrary<?> generate() {
        ArbitraryGeneratorContext context = this.generateContext(this.rootNode, this.customizers, null);
        return this.generateIntrospected(context, this.rootNode).combined();
    }

    private ArbitraryGeneratorContext generateContext(ObjectNode objectNode, List<MatcherOperator<? extends FixtureCustomizer>> customizers, @Nullable ArbitraryGeneratorContext parentContext) {
        HashMap<ArbitraryProperty, ObjectNode> childNodesByArbitraryProperty = new HashMap<ArbitraryProperty, ObjectNode>();
        ArrayList<ArbitraryProperty> childrenProperties = new ArrayList<ArbitraryProperty>();
        ArbitraryProperty arbitraryProperty = objectNode.getArbitraryProperty();
        Property resolvedParentProperty = objectNode.getResolvedProperty();
        List children = objectNode.getChildren().stream().filter(it -> resolvedParentProperty.equals(it.getResolvedParentProperty())).collect(Collectors.toList());
        for (ObjectNode childNode : children) {
            childNodesByArbitraryProperty.put(childNode.getArbitraryProperty(), childNode);
            childrenProperties.add(childNode.getArbitraryProperty());
        }
        ArrayList<MatcherOperator<? extends FixtureCustomizer>> arbitraryCustomizers = new ArrayList<MatcherOperator<? extends FixtureCustomizer>>();
        arbitraryCustomizers.addAll(this.generateOptions.getArbitraryCustomizers());
        arbitraryCustomizers.addAll(customizers);
        MonkeyGeneratorContext monkeyGeneratorContext = this.monkeyContext.retrieveGeneratorContext(this.rootProperty);
        return new ArbitraryGeneratorContext(resolvedParentProperty, arbitraryProperty, childrenProperties, parentContext, (ctx, prop) -> {
            ObjectNode node = (ObjectNode)childNodesByArbitraryProperty.get(prop);
            if (node == null) {
                return new FixedCombinableArbitrary(Arbitraries.just(null));
            }
            return this.generateIntrospected((ArbitraryGeneratorContext)ctx, node);
        }, arbitraryCustomizers, monkeyGeneratorContext);
    }

    private CombinableArbitrary generateIntrospected(ArbitraryGeneratorContext ctx, ObjectNode node) {
        FixedCombinableArbitrary generated;
        ArbitraryProperty prop = node.getArbitraryProperty();
        if (node.getArbitrary() != null) {
            generated = new FixedCombinableArbitrary(node.getArbitrary().injectNull(node.getArbitraryProperty().getObjectProperty().getNullInject()));
        } else {
            ArbitraryGeneratorContext childArbitraryGeneratorContext = this.generateContext(node, this.customizers, ctx);
            CombinableArbitrary cached = this.monkeyContext.getCachedArbitrary(node.getProperty());
            boolean notCustomized = ctx.getFixtureCustomizers().stream().noneMatch(it -> it.match(node.getProperty()));
            if (node.isNotManipulated() && notCustomized && cached != null) {
                generated = cached;
            } else {
                generated = this.generateOptions.getArbitraryGenerator(node.getResolvedProperty()).generate(childArbitraryGeneratorContext);
                if (node.isNotManipulated() && notCustomized) {
                    this.monkeyContext.putCachedArbitrary(node.getProperty(), (CombinableArbitrary)generated);
                }
            }
        }
        List<Predicate> arbitraryFilters = node.getArbitraryFilters();
        for (Predicate predicate : arbitraryFilters) {
            generated = generated.filter(predicate);
        }
        return generated.map(object -> ctx.getFixtureCustomizers().stream().filter(it -> it.match(node.getProperty())).map(MatcherOperator::getOperator).findFirst().map(it -> it.customizeFixture(object)).orElse(object));
    }
}

