/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.FixtureMonkeyBuilder;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.type.LazyAnnotatedType;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.resolver.ArbitraryResolver;
import com.navercorp.fixturemonkey.resolver.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public class FixtureMonkey {
    private final FixtureMonkeyOptions fixtureMonkeyOptions;
    private final ArbitraryTraverser traverser;
    private final ManipulatorOptimizer manipulatorOptimizer;
    private final MonkeyContext monkeyContext;
    private final List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders = new ArrayList();
    private final MonkeyExpressionFactory monkeyExpressionFactory;

    public FixtureMonkey(FixtureMonkeyOptions fixtureMonkeyOptions, ArbitraryTraverser traverser, ManipulatorOptimizer manipulatorOptimizer, MonkeyContext monkeyContext, List<MatcherOperator<Function<FixtureMonkey, ? extends ArbitraryBuilder<?>>>> registeredArbitraryBuilders, MonkeyExpressionFactory monkeyExpressionFactory) {
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
        this.traverser = traverser;
        this.manipulatorOptimizer = manipulatorOptimizer;
        this.monkeyContext = monkeyContext;
        this.monkeyExpressionFactory = monkeyExpressionFactory;
        this.initializeRegisteredArbitraryBuilders(registeredArbitraryBuilders);
    }

    public static FixtureMonkeyBuilder builder() {
        return new FixtureMonkeyBuilder();
    }

    public static FixtureMonkey create() {
        return FixtureMonkey.builder().build();
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(Class<T> type) {
        TypeReference typeReference = new TypeReference<T>(type){};
        return this.giveMeBuilder((T)typeReference);
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(TypeReference<T> type) {
        RootProperty rootProperty = new RootProperty(type.getAnnotatedType());
        ArbitraryBuilder registered = this.registeredArbitraryBuilders.stream().filter(it -> it.match((Property)rootProperty)).map(MatcherOperator::getOperator).findAny().orElse(null);
        if (registered != null) {
            return registered.copy();
        }
        MonkeyManipulatorFactory monkeyManipulatorFactory = new MonkeyManipulatorFactory(new AtomicInteger(), this.monkeyExpressionFactory, this.traverser, this.fixtureMonkeyOptions.getDecomposedContainerValueFactory());
        return new DefaultArbitraryBuilder(this.fixtureMonkeyOptions, rootProperty, new ArbitraryResolver(this.traverser, this.manipulatorOptimizer, monkeyManipulatorFactory, this.fixtureMonkeyOptions, this.monkeyContext, this.registeredArbitraryBuilders), this.traverser, monkeyManipulatorFactory, new ArbitraryBuilderContext(), this.registeredArbitraryBuilders, this.monkeyContext);
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(T value) {
        MonkeyManipulatorFactory monkeyManipulatorFactory = new MonkeyManipulatorFactory(new AtomicInteger(), this.monkeyExpressionFactory, this.traverser, this.fixtureMonkeyOptions.getDecomposedContainerValueFactory());
        ArbitraryBuilderContext context = new ArbitraryBuilderContext();
        ArbitraryManipulator arbitraryManipulator = monkeyManipulatorFactory.newArbitraryManipulator("$", value);
        context.addManipulator(arbitraryManipulator);
        return new DefaultArbitraryBuilder(this.fixtureMonkeyOptions, new RootProperty((AnnotatedType)new LazyAnnotatedType(() -> value)), new ArbitraryResolver(this.traverser, this.manipulatorOptimizer, monkeyManipulatorFactory, this.fixtureMonkeyOptions, this.monkeyContext, this.registeredArbitraryBuilders), this.traverser, monkeyManipulatorFactory, context, this.registeredArbitraryBuilders, this.monkeyContext);
    }

    public <T> Stream<T> giveMe(Class<T> type) {
        return Stream.generate(() -> this.giveMeBuilder((Object)type).sample());
    }

    public <T> Stream<T> giveMe(TypeReference<T> typeReference) {
        return Stream.generate(() -> this.giveMeBuilder((Object)typeReference).sample());
    }

    public <T> List<T> giveMe(Class<T> type, int size) {
        return this.giveMe(type).limit(size).collect(Collectors.toList());
    }

    public <T> List<T> giveMe(TypeReference<T> typeReference, int size) {
        return this.giveMe(typeReference).limit(size).collect(Collectors.toList());
    }

    public <T> T giveMeOne(Class<T> type) {
        return this.giveMe(type, 1).get(0);
    }

    public <T> T giveMeOne(TypeReference<T> typeReference) {
        return this.giveMe(typeReference, 1).get(0);
    }

    public <T> Arbitrary<T> giveMeArbitrary(Class<T> type) {
        return this.giveMeBuilder((T)type).build();
    }

    public <T> Arbitrary<T> giveMeArbitrary(TypeReference<T> typeReference) {
        return this.giveMeBuilder((T)typeReference).build();
    }

    private void initializeRegisteredArbitraryBuilders(List<MatcherOperator<Function<FixtureMonkey, ? extends ArbitraryBuilder<?>>>> registeredArbitraryBuilders) {
        List generatedRegisteredArbitraryBuilder = registeredArbitraryBuilders.stream().map(it -> new MatcherOperator(it.getMatcher(), (Object)((ArbitraryBuilder)((Function)it.getOperator()).apply(this)))).collect(Collectors.toList());
        for (int i = generatedRegisteredArbitraryBuilder.size() - 1; i >= 0; --i) {
            this.registeredArbitraryBuilders.add((MatcherOperator)generatedRegisteredArbitraryBuilder.get(i));
        }
    }
}

