/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.customizer.ApplyNodeCountManipulator;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.InnerSpecState;
import com.navercorp.fixturemonkey.customizer.ManipulatorSet;
import com.navercorp.fixturemonkey.customizer.NodeFilterManipulator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.customizer.NodeNullityManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetDecomposedValueManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetJustManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetLazyManipulator;
import com.navercorp.fixturemonkey.customizer.Values;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.resolver.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.PropertyPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.10", status=API.Status.MAINTAINED)
public final class MonkeyManipulatorFactory {
    private final AtomicInteger sequence;
    private final MonkeyExpressionFactory monkeyExpressionFactory;
    private final ArbitraryTraverser traverser;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;

    public MonkeyManipulatorFactory(AtomicInteger sequence, MonkeyExpressionFactory monkeyExpressionFactory, ArbitraryTraverser traverser, DecomposedContainerValueFactory decomposedContainerValueFactory) {
        this.sequence = sequence;
        this.monkeyExpressionFactory = monkeyExpressionFactory;
        this.traverser = traverser;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
    }

    public ArbitraryManipulator newArbitraryManipulator(String expression, @Nullable Object value, int limit) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), this.convertToNodeManipulator(value, limit));
    }

    public ArbitraryManipulator newArbitraryManipulator(String expression, @Nullable Object value) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), this.convertToNodeManipulator(this.sequence.getAndIncrement(), value));
    }

    public <T> ArbitraryManipulator newArbitraryManipulator(String expression, Class<T> type, Predicate<T> filter, int limit) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), new ApplyNodeCountManipulator(new NodeFilterManipulator(type, filter), limit));
    }

    public ContainerInfoManipulator newContainerInfoManipulator(String expression, int min, int max) {
        int newSequence = this.sequence.getAndIncrement();
        return new ContainerInfoManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver().toNextNodePredicate(), new ArbitraryContainerInfo(min, max), newSequence);
    }

    public List<ArbitraryManipulator> newRegisteredArbitraryManipulators(List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders, Map<Property, List<ObjectNode>> nodesByType) {
        ArrayList<ArbitraryManipulator> manipulators = new ArrayList<ArbitraryManipulator>();
        for (Map.Entry<Property, List<ObjectNode>> nodeByType : nodesByType.entrySet()) {
            Property property = nodeByType.getKey();
            List<ObjectNode> objectNodes = nodeByType.getValue();
            DefaultArbitraryBuilder registeredArbitraryBuilder = registeredArbitraryBuilders.stream().filter(it -> it.match(property)).findFirst().map(MatcherOperator::getOperator).filter(it -> it instanceof DefaultArbitraryBuilder).orElse(null);
            if (registeredArbitraryBuilder == null) continue;
            ArbitraryBuilderContext context = registeredArbitraryBuilder.getContext();
            List arbitraryManipulators = context.getManipulators().stream().map(it -> it.withPrependNodeResolver(this.prependPropertyNodeResolver(property, objectNodes))).collect(Collectors.toList());
            manipulators.addAll(arbitraryManipulators);
        }
        return manipulators;
    }

    public ManipulatorSet newManipulatorSet(InnerSpecState.ManipulatorHolderSet manipulatorHolderSet) {
        int baseSequence = this.sequence.getAndIncrement();
        ArrayList<ArbitraryManipulator> arbitraryManipulators = new ArrayList<ArbitraryManipulator>();
        List setArbitraryManipulators = manipulatorHolderSet.getNodeResolverObjectHolders().stream().map(it -> new ArbitraryManipulator(it.getNodeResolver(), this.convertToNodeManipulator(baseSequence + it.getSequence(), it.getValue()))).collect(Collectors.toList());
        List filterArbitraryManipulators = manipulatorHolderSet.getPostConditionManipulators().stream().map(it -> new ArbitraryManipulator(it.getNodeResolver(), new NodeFilterManipulator(it.getType(), it.getPredicate()))).collect(Collectors.toList());
        arbitraryManipulators.addAll(setArbitraryManipulators);
        arbitraryManipulators.addAll(filterArbitraryManipulators);
        List<ContainerInfoManipulator> containerInfoManipulators = manipulatorHolderSet.getContainerInfoManipulators().stream().map(it -> new ContainerInfoManipulator(it.getNodeResolver().toNextNodePredicate(), new ArbitraryContainerInfo(it.getElementMinSize(), it.getElementMaxSize()), baseSequence + it.getSequence())).collect(Collectors.toList());
        this.sequence.set(this.sequence.get() + containerInfoManipulators.size() + arbitraryManipulators.size());
        return new ManipulatorSet(arbitraryManipulators, containerInfoManipulators);
    }

    public MonkeyManipulatorFactory copy() {
        return new MonkeyManipulatorFactory(new AtomicInteger(this.sequence.get()), this.monkeyExpressionFactory, this.traverser, this.decomposedContainerValueFactory);
    }

    private NodeManipulator convertToNodeManipulator(@Nullable Object value, int limit) {
        NodeManipulator nodeManipulator = this.convertToNodeManipulator(this.sequence.getAndIncrement(), value);
        return new ApplyNodeCountManipulator(nodeManipulator, limit);
    }

    private NodeManipulator convertToNodeManipulator(int sequence, @Nullable Object value) {
        if (value == null) {
            return new NodeNullityManipulator(true);
        }
        if (value == Values.NOT_NULL) {
            return new NodeNullityManipulator(false);
        }
        if (value instanceof Values.Just) {
            return new NodeSetJustManipulator((Values.Just)value);
        }
        if (value instanceof Arbitrary) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.decomposedContainerValueFactory, LazyArbitrary.lazy(() -> ((Arbitrary)value).sample()));
        }
        if (value instanceof DefaultArbitraryBuilder) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.decomposedContainerValueFactory, LazyArbitrary.lazy(() -> ((DefaultArbitraryBuilder)value).sample()));
        }
        if (value instanceof Supplier) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.decomposedContainerValueFactory, LazyArbitrary.lazy((Supplier)((Supplier)value)));
        }
        if (value instanceof LazyArbitrary) {
            return new NodeSetLazyManipulator(sequence, this.traverser, this.decomposedContainerValueFactory, (LazyArbitrary)value);
        }
        return new NodeSetDecomposedValueManipulator<Object>(sequence, this.traverser, this.decomposedContainerValueFactory, value);
    }

    private NodeResolver prependPropertyNodeResolver(final Property property, final List<ObjectNode> objectNodes) {
        return new NodeResolver(){

            @Override
            public List<ObjectNode> resolve(ObjectNode objectNode) {
                for (ObjectNode node : objectNodes) {
                    for (ObjectNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                    }
                }
                return objectNodes;
            }

            @Override
            public List<NextNodePredicate> toNextNodePredicate() {
                return Collections.singletonList(new PropertyPredicate(property));
            }
        };
    }
}

