/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.customizer.NodeNullityManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetDecomposedValueManipulator;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class NodeSetLazyManipulator<T>
implements NodeManipulator {
    private final int sequence;
    private final ArbitraryTraverser traverser;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;
    private final LazyArbitrary<T> lazyArbitrary;

    public NodeSetLazyManipulator(int sequence, ArbitraryTraverser traverser, DecomposedContainerValueFactory decomposedContainerValueFactory, LazyArbitrary<T> lazyArbitrary) {
        this.sequence = sequence;
        this.traverser = traverser;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        this.lazyArbitrary = lazyArbitrary;
    }

    @Override
    public void manipulate(ObjectNode objectNode) {
        Object value = this.lazyArbitrary.getValue();
        if (value == null) {
            NodeNullityManipulator nullityManipulator = new NodeNullityManipulator(true);
            nullityManipulator.manipulate(objectNode);
            return;
        }
        if (value instanceof Arbitrary) {
            value = ((Arbitrary)value).sample();
        }
        NodeSetDecomposedValueManipulator<Object> nodeSetDecomposedValueManipulator = new NodeSetDecomposedValueManipulator<Object>(this.sequence, this.traverser, this.decomposedContainerValueFactory, value);
        nodeSetDecomposedValueManipulator.manipulate(objectNode);
        this.lazyArbitrary.clear();
    }
}

