/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryBuilderContext {
    private final List<ArbitraryManipulator> manipulators;
    private final List<ContainerInfoManipulator> containerInfoManipulators;
    private boolean validOnly;
    @Nullable
    private FixedState fixedState = null;
    @Nullable
    private CombinableArbitrary<?> fixedCombinableArbitrary;

    public ArbitraryBuilderContext(List<ArbitraryManipulator> manipulators, List<ContainerInfoManipulator> containerInfoManipulators, boolean validOnly, @Nullable FixedState fixedState, @Nullable CombinableArbitrary<?> fixedCombinableArbitrary) {
        this.manipulators = manipulators;
        this.containerInfoManipulators = containerInfoManipulators;
        this.validOnly = validOnly;
        this.fixedState = fixedState;
        this.fixedCombinableArbitrary = fixedCombinableArbitrary;
    }

    public ArbitraryBuilderContext() {
        this(new ArrayList<ArbitraryManipulator>(), new ArrayList<ContainerInfoManipulator>(), true, null, null);
    }

    public ArbitraryBuilderContext copy() {
        List<ContainerInfoManipulator> copiedContainerInfoManipulators = this.containerInfoManipulators.stream().map(ContainerInfoManipulator::copy).collect(Collectors.toList());
        return new ArbitraryBuilderContext(new ArrayList<ArbitraryManipulator>(this.manipulators), copiedContainerInfoManipulators, this.validOnly, this.fixedState, this.fixedCombinableArbitrary);
    }

    public void addManipulator(ArbitraryManipulator arbitraryManipulator) {
        this.manipulators.add(arbitraryManipulator);
    }

    public void addManipulators(Collection<ArbitraryManipulator> arbitraryManipulators) {
        this.manipulators.addAll(arbitraryManipulators);
    }

    public List<ArbitraryManipulator> getManipulators() {
        return Collections.unmodifiableList(this.manipulators);
    }

    public void addContainerInfoManipulator(ContainerInfoManipulator containerInfo) {
        this.containerInfoManipulators.add(containerInfo);
    }

    public void addContainerInfoManipulators(List<ContainerInfoManipulator> containerInfoManipulators) {
        this.containerInfoManipulators.addAll(containerInfoManipulators);
    }

    public List<ContainerInfoManipulator> getContainerInfoManipulators() {
        return Collections.unmodifiableList(this.containerInfoManipulators);
    }

    public void setValidOnly(boolean validOnly) {
        this.validOnly = validOnly;
    }

    public boolean isValidOnly() {
        return this.validOnly;
    }

    public void markFixed() {
        if (this.fixedState != null && this.fixedState.getFixedManipulateSize() == this.manipulators.size() && this.fixedState.getFixedContainerManipulatorSize() == this.containerInfoManipulators.size()) {
            return;
        }
        this.fixedState = new FixedState(this.manipulators.size(), this.containerInfoManipulators.size());
        this.fixedCombinableArbitrary = null;
    }

    public boolean isFixed() {
        return this.fixedState != null;
    }

    public boolean fixedExpired() {
        return this.manipulators.size() > Objects.requireNonNull(this.fixedState).getFixedManipulateSize() || this.containerInfoManipulators.size() > this.fixedState.getFixedContainerManipulatorSize();
    }

    public void renewFixed(CombinableArbitrary<?> fixedCombinableArbitrary) {
        this.markFixed();
        this.fixedCombinableArbitrary = fixedCombinableArbitrary;
    }

    @Nullable
    public CombinableArbitrary<?> getFixedCombinableArbitrary() {
        return this.fixedCombinableArbitrary;
    }

    private static class FixedState {
        private final int fixedManipulateSize;
        private final int fixedContainerManipulatorSize;

        public FixedState(int fixedManipulateSize, int fixedContainerManipulatorSize) {
            this.fixedManipulateSize = fixedManipulateSize;
            this.fixedContainerManipulatorSize = fixedContainerManipulatorSize;
        }

        public int getFixedManipulateSize() {
            return this.fixedManipulateSize;
        }

        public int getFixedContainerManipulatorSize() {
            return this.fixedContainerManipulatorSize;
        }
    }
}

