/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.resolver.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.resolver.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.resolver.ResolvedCombinableArbitrary;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import com.navercorp.fixturemonkey.tree.ObjectTree;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryResolver {
    private final ArbitraryTraverser traverser;
    private final ManipulatorOptimizer manipulatorOptimizer;
    private final MonkeyManipulatorFactory monkeyManipulatorFactory;
    private final FixtureMonkeyOptions fixtureMonkeyOptions;
    private final MonkeyContext monkeyContext;
    private final List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders;

    public ArbitraryResolver(ArbitraryTraverser traverser, ManipulatorOptimizer manipulatorOptimizer, MonkeyManipulatorFactory monkeyManipulatorFactory, FixtureMonkeyOptions fixtureMonkeyOptions, MonkeyContext monkeyContext, List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders) {
        this.traverser = traverser;
        this.manipulatorOptimizer = manipulatorOptimizer;
        this.monkeyManipulatorFactory = monkeyManipulatorFactory;
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
        this.monkeyContext = monkeyContext;
        this.registeredArbitraryBuilders = registeredArbitraryBuilders;
    }

    public CombinableArbitrary<?> resolve(RootProperty rootProperty, ArbitraryBuilderContext builderContext) {
        List<ArbitraryManipulator> manipulators = builderContext.getManipulators();
        List<ContainerInfoManipulator> containerInfoManipulators = builderContext.getContainerInfoManipulators();
        List registeredContainerInfoManipulators = this.registeredArbitraryBuilders.stream().map(it -> new MatcherOperator(it.getMatcher(), ((DefaultArbitraryBuilder)it.getOperator()).getContext().getContainerInfoManipulators())).collect(Collectors.toList());
        return new ResolvedCombinableArbitrary(rootProperty, () -> new ObjectTree(rootProperty, this.traverser.traverse((Property)rootProperty, containerInfoManipulators, registeredContainerInfoManipulators), this.fixtureMonkeyOptions, this.monkeyContext), objectTree -> {
            List<ArbitraryManipulator> registeredManipulators = this.monkeyManipulatorFactory.newRegisteredArbitraryManipulators(this.registeredArbitraryBuilders, objectTree.getMetadata().getNodesByProperty());
            List<ArbitraryManipulator> joinedManipulators = Stream.concat(registeredManipulators.stream(), manipulators.stream()).collect(Collectors.toList());
            List<ArbitraryManipulator> optimizedManipulator = this.manipulatorOptimizer.optimize(joinedManipulators).getManipulators();
            for (ArbitraryManipulator manipulator : optimizedManipulator) {
                manipulator.manipulate((ObjectTree)objectTree);
            }
        }, this.fixtureMonkeyOptions.getGenerateMaxTries(), this.fixtureMonkeyOptions.getDefaultArbitraryValidator(), builderContext.isValidOnly());
    }
}

